/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.GlossyButton;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import plot.Globals;
import plot.JOptionPanes;

class FrmUpdate
extends JDialog
implements PropertyChangeListener {
    private final String BASEURL = "http://www.plasmidplotter.com/";
    private final String UPDATEFILE = "pLOTUpdates.xml";
    private final String UPDATEFILEURL = "http://www.plasmidplotter.com/pLOTUpdates.xml";
    private int totalBytes = 0;
    private static final int BUFFERSIZE = 1024;
    private String id = "";
    private String fileContents = "";
    private boolean gbLoaded = false;
    private JCheckBox chkFeatures;
    private JCheckBox chkLadders;
    private JCheckBox chkMain;
    private JCheckBox chkRE;
    private GlossyButton cmdCheck;
    private GlossyButton cmdClose;
    private GlossyButton cmdUpdateItems;
    private GlossyButton cmdVisitPLOT;
    private JPanel jPanel1;
    private JLabel lblStatus;

    public boolean loaded() {
        return this.gbLoaded;
    }

    public FrmUpdate(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setIconImage(Globals.icon.getImage());
        this.setLocationRelativeTo(parent);
        String cancelName = "cancel";
        String okName = "OK";
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelName);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), okName);
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put(cancelName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmUpdate.this.doCancel();
            }
        });
        actionMap.put(okName, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmUpdate.this.checkUpdates();
            }
        });
    }

    private void checkUpdates() {
    }

    private void doCancel() {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cmdCheck = new GlossyButton();
        this.cmdClose = new GlossyButton();
        this.cmdVisitPLOT = new GlossyButton();
        this.cmdUpdateItems = new GlossyButton();
        this.chkFeatures = new JCheckBox();
        this.chkRE = new JCheckBox();
        this.chkLadders = new JCheckBox();
        this.chkMain = new JCheckBox();
        this.lblStatus = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("pLOT Update Checker");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Available Updates"));
        this.cmdCheck.setText("Check for Updates");
        this.cmdCheck.setColorHot(new Color(204, 204, 255));
        this.cmdCheck.setColorNormal(new Color(204, 204, 255));
        this.cmdCheck.setColorPressed(new Color(204, 204, 255));
        this.cmdCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUpdate.this.cmdCheckActionPerformed(evt);
            }
        });
        this.cmdClose.setText("Close");
        this.cmdClose.setColorHot(new Color(255, 102, 102));
        this.cmdClose.setColorNormal(new Color(255, 102, 102));
        this.cmdClose.setColorPressed(new Color(255, 102, 102));
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmUpdate.this.cmdCloseActionPerformed(evt);
            }
        });
        this.cmdVisitPLOT.setText("Visit pLOT Site");
        this.cmdVisitPLOT.setColorHot(new Color(204, 204, 255));
        this.cmdVisitPLOT.setColorNormal(new Color(204, 204, 255));
        this.cmdVisitPLOT.setColorPressed(new Color(204, 204, 255));
        this.cmdUpdateItems.setText("Update Selected Items");
        this.cmdUpdateItems.setColorHot(new Color(204, 204, 255));
        this.cmdUpdateItems.setColorNormal(new Color(204, 204, 255));
        this.cmdUpdateItems.setColorPressed(new Color(204, 204, 255));
        this.cmdUpdateItems.setEnabled(false);
        this.chkFeatures.setText("Default Features LIbrary");
        this.chkFeatures.setEnabled(false);
        this.chkRE.setText("Restriction Enzyme LIbrary");
        this.chkRE.setActionCommand("");
        this.chkRE.setEnabled(false);
        this.chkLadders.setText("Default Ladders LIbrary");
        this.chkLadders.setActionCommand("Restriction Enzyme LIbrary");
        this.chkLadders.setEnabled(false);
        this.chkMain.setText("Executable/Main Program");
        this.chkMain.setActionCommand("Restriction Enzyme LIbrary");
        this.chkMain.setEnabled(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chkRE, -1, 257, Short.MAX_VALUE).addComponent(this.chkFeatures, -1, -1, Short.MAX_VALUE).addComponent(this.chkLadders, -1, -1, Short.MAX_VALUE).addComponent(this.chkMain, -1, -1, Short.MAX_VALUE)).addGap(0, 32, Short.MAX_VALUE)).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmdCheck, -1, -1, Short.MAX_VALUE).addComponent(this.cmdClose, -1, -1, Short.MAX_VALUE).addComponent(this.cmdVisitPLOT, -2, 126, -2)).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.cmdUpdateItems, -2, 170, -2).addContainerGap(197, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblStatus, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.chkFeatures).addGap(18, 18, 18).addComponent(this.chkRE).addGap(18, 18, 18).addComponent(this.chkLadders).addGap(18, 18, 18).addComponent(this.chkMain).addGap(103, 103, 103)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.cmdCheck, -2, 41, -2).addGap(18, 18, 18).addComponent(this.cmdClose, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cmdVisitPLOT, -2, 41, -2).addContainerGap()).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(204, Short.MAX_VALUE).addComponent(this.cmdUpdateItems, -2, 41, -2).addContainerGap())));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void cmdCheckActionPerformed(ActionEvent evt) {
        this.cmdCheck.setEnabled(false);
        this.cmdClose.setEnabled(false);
        this.cmdUpdateItems.setEnabled(false);
        this.chkFeatures.setEnabled(false);
        this.chkRE.setEnabled(false);
        this.chkLadders.setEnabled(false);
        this.chkMain.setEnabled(false);
        DownloadTask task = new DownloadTask(this, "http://www.plasmidplotter.com/pLOTUpdates.xml");
        task.addPropertyChangeListener(this);
        task.execute();
    }

    private Document ParseXMLString(String fileString) {
        ByteArrayInputStream input;
        try {
            input = new ByteArrayInputStream(this.fileContents.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                Document doc = builder.parse(input);
                return doc;
            }
            catch (IOException | SAXException ex) {
                return null;
            }
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
    }

    private void completedDownload() {
        if (this.fileContents.length() != 0) {
            this.chkFeatures.setEnabled(true);
            this.chkRE.setEnabled(true);
            this.chkLadders.setEnabled(true);
            this.chkMain.setEnabled(true);
            Document doc = this.ParseXMLString(this.fileContents);
            if (doc != null) {
                Element root = doc.getDocumentElement();
                if (!root.getNodeName().equals("pLOTUpdates")) {
                    return;
                }
                NodeList nList = doc.getElementsByTagName("Update");
                StringBuilder Comments = new StringBuilder();
                block6: for (int temp = 0; temp < nList.getLength(); ++temp) {
                    String cComment = "";
                    Node nNode = nList.item(temp);
                    NamedNodeMap attributes = nNode.getAttributes();
                    String updateType = attributes.getNamedItem("type").getNodeValue();
                    String updateVersion = attributes.getNamedItem("version").getNodeValue();
                    NodeList cList = nNode.getChildNodes();
                    for (int ctemp = 0; ctemp < cList.getLength(); ++ctemp) {
                        Node cNode = cList.item(ctemp);
                        if (!cNode.getNodeName().equals("Comments")) continue;
                        cComment = cNode.getNodeValue();
                    }
                    switch (updateType) {
                        case "pLOTExecutableJ": {
                            if (updateVersion.equals("1.0.0")) continue block6;
                            this.chkMain.setEnabled(true);
                            if (cComment.length() <= 0) continue block6;
                            Comments.append("\n----------------------------------\nMain Executable Update\n----------------------------------\n").append(cComment);
                            continue block6;
                        }
                    }
                }
                System.err.println(Comments.toString());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
    }

    public class DownloadTask
    extends SwingWorker<Void, Void> {
        private String downloadURL;
        private FrmUpdate gui;
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public DownloadTask(FrmUpdate gui, String downloadURL) {
            this.gui = gui;
            this.downloadURL = downloadURL;
        }

        @Override
        protected Void doInBackground() throws Exception {
            try {
                int bytesRead;
                FrmUpdate.this.lblStatus.setText("Connecting to pLOT Site..");
                URL url = new URL(this.downloadURL);
                InputStream in = url.openStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    FrmUpdate.this.totalBytes += bytesRead;
                    this.output.write(buffer, 0, bytesRead);
                    FrmUpdate.this.lblStatus.setText("Downloading Update Manifest: " + FrmUpdate.this.totalBytes);
                }
            }
            catch (MalformedURLException ex) {
                FrmUpdate.this.lblStatus.setText("Download error");
                JOptionPanes.showMessageDialog(this.gui, "Failed to retreive Update Manifest", "Retrieval Error", 0);
                this.cancel(true);
            }
            catch (IOException ex) {
                FrmUpdate.this.lblStatus.setText("Download error");
                if (ex.getMessage().startsWith("Server returned HTTP response code: 400")) {
                    JOptionPanes.showMessageDialog(this.gui, "Failed to retreive Update Manifest: " + FrmUpdate.this.id + "\nServer could not find the file", "Retrieval Error", 0);
                } else {
                    JOptionPanes.showMessageDialog(this.gui, "Failed to retreive Update Manifest: " + FrmUpdate.this.id + "\n" + ex.getMessage(), "Retrieval Error", 0);
                }
                this.cancel(true);
            }
            return null;
        }

        @Override
        protected void done() {
            FrmUpdate.this.lblStatus.setText("");
            FrmUpdate.this.cmdCheck.setEnabled(true);
            FrmUpdate.this.cmdClose.setEnabled(true);
            FrmUpdate.this.cmdUpdateItems.setEnabled(true);
            if (!this.isCancelled()) {
                FrmUpdate.this.fileContents = this.output.toString();
                FrmUpdate.this.completedDownload();
            }
        }
    }
}

