/*
 * Decompiled with CFR 0.152.
 */
package plot;

import FileConverters.ImpFileReader;
import GenbankFileReader.GenBankFile;
import java.io.File;
import plot.DefaultConverter;

class GBFileReader
extends GenBankFile
implements ImpFileReader,
DefaultConverter {
    private static String[] extensions = new String[]{"gb", "gbk", "ape", "plt"};

    GBFileReader() {
    }

    @Override
    public String[] getReadFileExtensions() {
        return extensions;
    }

    @Override
    public String getReadFormatDescription() {
        return "Genbank Text File";
    }

    @Override
    public GenBankFile loadFile(File file) {
        return GBFileReader.loadGBFile(file);
    }

    @Override
    public boolean acceptFileForRead(File file) {
        String lc = file.getAbsolutePath().toLowerCase();
        return lc.endsWith("gb") || lc.endsWith("gbk") || lc.endsWith("ape") || lc.endsWith("plt");
    }

    @Override
    public int getSortOrder() {
        return 1;
    }

    @Override
    public String getReadError() {
        return "";
    }
}

