/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import plot.FeatureRenderer;
import plot.Globals;

class GraphicsTypeCellRenderer
extends JLabel
implements TableCellRenderer {
    public GraphicsTypeCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color fColor;
        Color bColor;
        if (isSelected) {
            bColor = table.getSelectionBackground();
            fColor = table.getSelectionForeground();
        } else {
            bColor = table.getBackground();
            fColor = table.getForeground();
        }
        this.setBackground(bColor != null ? bColor : Color.WHITE);
        this.setForeground(fColor != null ? fColor : Color.BLACK);
        this.setFont(table.getFont());
        if (value != null) {
            if (value instanceof FeatureRenderer) {
                this.setText(((FeatureRenderer)value).getName());
                if (value instanceof FeatureRenderer.BoxArrowFeature) {
                    this.setIcon(Globals.getGraphicIcons(2));
                } else if (value instanceof FeatureRenderer.HeadlessArrowFeature) {
                    this.setIcon(Globals.getGraphicIcons(3));
                } else if (value instanceof FeatureRenderer.LineArrowFeature) {
                    this.setIcon(Globals.getGraphicIcons(4));
                } else if (value instanceof FeatureRenderer.LineFeature) {
                    this.setIcon(Globals.getGraphicIcons(0));
                } else if (value instanceof FeatureRenderer.TickMarkFeature) {
                    this.setIcon(Globals.getGraphicIcons(5));
                } else if (value instanceof FeatureRenderer.BoxFeature) {
                    this.setIcon(Globals.getGraphicIcons(1));
                } else if (value instanceof FeatureRenderer.BracketFeature) {
                    this.setIcon(Globals.getGraphicIcons(6));
                } else if (value instanceof FeatureRenderer.NoGraphicFeature) {
                    this.setIcon(Globals.getGraphicIcons(7));
                }
            } else if (value instanceof Integer) {
                int val = (Integer)value;
                Icon i = Globals.getGraphicIcons(val);
                this.setIcon(i);
                this.setText(i != null ? FeatureRenderer.drawFeatures[val].getName() : "");
            }
        } else {
            this.setIcon(null);
            this.setText("");
        }
        return this;
    }
}

