/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

class JOptionPanes {
    JOptionPanes() {
    }

    public static int showConfirmDialog(Component parentComponent, Object message) {
        return JOptionPanes.showConfirmDialog(parentComponent, message, "Confirm", 1);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, int messageType, int optionType) {
        return JOptionPanes.showConfirmDialog(parentComponent, message, "Confirm", messageType, optionType);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return JOptionPanes.showConfirmDialog(parentComponent, message, title, 3, optionType);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int messageType, int optionType) {
        return JOptionPanes.showConfirmDialog(parentComponent, message, title, messageType, optionType, null);
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int messageType, int optionType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        JOptionPanes.setDialogLocation(dialog, parentComponent);
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        Object[] options = pane.getOptions();
        if (options == null) {
            switch (optionType) {
                case 0: {
                    options = new Object[]{"Yes", "No"};
                    break;
                }
                case 1: {
                    options = new Object[]{"Yes", "No", "Cancel"};
                    break;
                }
                default: {
                    options = new Object[]{"OK"};
                }
            }
        }
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(selectedValue)) continue;
            return i;
        }
        return -1;
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        JOptionPanes.showMessageDialog(parentComponent, message, "Message", 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title) {
        JOptionPanes.showMessageDialog(parentComponent, message, title, 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPanes.showMessageDialog(parentComponent, message, title, messageType, null);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType, -1, icon);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        JOptionPanes.setDialogLocation(dialog, parentComponent);
        dialog.setVisible(true);
    }

    static void setDialogLocation(JDialog dialog, Component parentComponent) {
        if (parentComponent == null || !(parentComponent instanceof Frame) || ((Frame)parentComponent).getExtendedState() == 1) {
            dialog.setLocationRelativeTo(null);
        } else {
            dialog.setLocationRelativeTo(parentComponent);
        }
    }

    public static String showInputDialog(Component parentComponent, Object message) {
        return JOptionPanes.showInputDialog(parentComponent, message, "Input");
    }

    public static String showInputDialog(Component parentComponent, Object message, String title) {
        return JOptionPanes.showInputDialog(parentComponent, message, title, 3);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) {
        return JOptionPanes.showInputDialog(parentComponent, message, title, messageType, null, null, null);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        return JOptionPanes.showInputDialog(parentComponent, message, title, messageType, icon, null, null);
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, messageType, 2, icon, null, null);
        pane.setWantsInput(true);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        JOptionPanes.setDialogLocation(dialog, parentComponent);
        dialog.setVisible(true);
        Object input = pane.getInputValue();
        if (input == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return input != null ? input.toString() : null;
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        JOptionPanes.setDialogLocation(dialog, parentComponent);
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (options == null) {
            switch (optionType) {
                case 0: {
                    options = new Object[]{"Yes", "No"};
                    break;
                }
                case 1: {
                    options = new Object[]{"Yes", "No", "Cancel"};
                    break;
                }
                default: {
                    options = new Object[]{"OK"};
                }
            }
        }
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals(selectedValue)) continue;
            return i;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return -1;
    }
}

