/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Encoders.Ascii85;
import GenbankFileReader.Reference;
import MiscTools.ColorTools;
import MiscTools.StringTools;
import java.awt.Color;
import java.io.Serializable;
import plot.Feature;
import plot.ProjectDocument;

class LibraryFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DNA_SEQ = 0;
    public static final int AA_SEQ = 1;
    public boolean isDefault = false;
    public String name = "";
    public String seq = "";
    public int type = 0;
    public Color color = Color.CYAN;
    public String category = "";
    public String gbType = "";
    public String comment = "";
    public String key = "";
    public int graphicType = 0;
    public String version = "";
    public String igVersion = "";
    public String references85 = "";
    public Reference[] references;

    LibraryFeature() {
    }

    public String exportToString() {
        return this.name + "\t" + this.seq + "\t" + this.type + "\t" + ColorTools.colorToInt(this.color) + "\t" + this.graphicType + "\t" + this.category + "\t" + this.gbType + "\t" + Ascii85.encode(this.comment) + "\t" + this.key + "\t" + this.version + "\t" + this.igVersion + "\t" + this.references85;
    }

    public LibraryFeature clone() {
        LibraryFeature l = new LibraryFeature();
        l.name = this.name;
        l.seq = this.seq;
        l.type = this.type;
        l.color = this.color;
        l.category = this.category;
        l.graphicType = this.graphicType;
        l.gbType = this.gbType;
        l.references85 = this.references85;
        l.isDefault = false;
        return l;
    }

    public static LibraryFeature fromFeature(Feature f, int type, ProjectDocument project) {
        LibraryFeature l = new LibraryFeature();
        l.name = f.getName();
        l.type = type;
        l.seq = type == 0 ? project.getSequence(f.getStart(), f.getStop(), f.isAntisense()) : project.getCodonTable().translate(project.getSequence(f.getStart(), f.getStop(), f.isAntisense()));
        l.color = f.getBackColor();
        l.graphicType = f.renderer.getValue();
        l.gbType = f.getGBType();
        l.comment = f.note != null && f.note.length() > 0 ? Ascii85.encode(f.note) : "";
        l.category = "";
        l.key = "";
        l.version = "";
        l.igVersion = "";
        l.references85 = "";
        return l;
    }

    public static LibraryFeature fromString(String line) {
        if (line != null && line.length() > 0 && !line.startsWith(";")) {
            String[] strings = line.split("\t");
            LibraryFeature feature = new LibraryFeature();
            if (strings.length > 0) {
                feature.name = strings[0];
            }
            if (strings.length > 1) {
                feature.seq = strings[1].toUpperCase();
            }
            if (strings.length > 2) {
                feature.type = StringTools.filterStringToInt(strings[2]);
            }
            if (strings.length > 3) {
                feature.color = ColorTools.intToColor(StringTools.filterStringToInt(strings[3]));
            }
            if (strings.length > 4) {
                feature.graphicType = StringTools.filterStringToInt(strings[4]);
            }
            if (strings.length > 5) {
                feature.category = strings[5];
            }
            if (strings.length > 6) {
                feature.gbType = strings[6];
            }
            if (strings.length > 7) {
                feature.comment = Ascii85.decode(strings[7]);
            }
            if (strings.length > 8) {
                feature.key = strings[8];
            }
            if (strings.length > 9) {
                feature.version = strings[9];
            }
            if (strings.length > 10) {
                feature.igVersion = strings[10];
            }
            if (strings.length > 11) {
                feature.references85 = strings[11];
            }
            return feature;
        }
        return null;
    }
}

