/*
 * Decompiled with CFR 0.152.
 */
package plot;

import Buttons.ButtonRenderer;
import Buttons.GlossyButton;
import DockingPanel.DockPanel;
import FileDialogs.FileDialog;
import IconListBoxes.IconListBox;
import ScrollPanels.StatusLabel;
import SequenceEditorPanels.SequenceEditorPanel;
import Sequences.SequenceExportFormat;
import java.awt.Frame;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import plot.ListDragListener;
import plot.MobileBlock;
import plot.SEFTransferHandler;

public class MobileBlocksPanel
extends JPanel {
    File currentFile;
    private final MouseListener menuMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            JComponent c = (JComponent)arg0.getComponent();
            ToolTipManager.sharedInstance().setEnabled(false);
            if (!(c instanceof JSeparator)) {
                MobileBlocksPanel.this.statusLabel.setText(c.getToolTipText(), 3000);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            MobileBlocksPanel.this.statusLabel.setText("");
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    };
    private boolean dropEnabled = true;
    private static final String helpText = "<html><b><u>Sequence Blocks</u></b><br>Drag and drop annotations from a project to the list to store the sequence, <br>and annotations properties.  These blocks can be dragged and dropped <br>into projects to insert the sequence and proterties into that project. <br><br>The list of stored sequence blocks can be saved to an external file and <br>loaded at a later timer using the Save, Save as, and Open buttons.<br><br>Sequence can be removed using the Delete button or the delete key.</html>";
    final String ext = ".blocks";
    private GlossyButton cmdDelete;
    private GlossyButton cmdOpen;
    private GlossyButton cmdSave;
    private GlossyButton cmdSaveAs;
    public DockPanel dockPanel;
    private SequenceEditorPanel editor;
    private JLabel jLabel1;
    private JScrollPane jScrollPane3;
    private JLabel lblHelp;
    private IconListBox lstBlocks;
    private StatusLabel statusLabel;

    public MobileBlocksPanel() {
        this.initComponents();
        this.dockPanel.getDockButton().addMouseListener(this.menuMouseListener);
        this.dockPanel.getDockButton().setToolTipText("Hide window");
        this.dockPanel.getAlwaysOnTopButton().addMouseListener(this.menuMouseListener);
        this.dockPanel.getMinimizeButton().addMouseListener(this.menuMouseListener);
        this.dockPanel.getMaximizeButton().addMouseListener(this.menuMouseListener);
        this.dockPanel.getCloseButton().addMouseListener(this.menuMouseListener);
        this.cmdSaveAs.addMouseListener(this.menuMouseListener);
        this.cmdDelete.addMouseListener(this.menuMouseListener);
        this.cmdSave.addMouseListener(this.menuMouseListener);
        this.lblHelp.setToolTipText(helpText);
        this.lstBlocks.clear();
        this.lstBlocks.setDragEnabled(true);
        this.lstBlocks.setDropMode(DropMode.INSERT);
        this.lstBlocks.setTransferHandler(new SEFTransferHandler(this.lstBlocks){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return MobileBlocksPanel.this.dropEnabled && super.canImport(support);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    SequenceExportFormat[] sef = (SequenceExportFormat[])support.getTransferable().getTransferData(SequenceExportFormat.copiedSequencesFlavor);
                    if (sef == null) {
                        return false;
                    }
                    JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
                    int index = dl.getIndex();
                    this.droppedItems(sef, index, index);
                    return true;
                }
                catch (UnsupportedFlavorException | IOException e) {
                    return false;
                }
            }

            @Override
            public void droppedItems(SequenceExportFormat[] sef, int x, int y) {
                if (x == -1) {
                    x = 0;
                }
                for (int index = 0; index < sef.length; ++index) {
                    MobileBlocksPanel.this.lstBlocks.addItem(new MobileBlock(sef[index]), x);
                }
            }
        });
        ListDragListener listener = new ListDragListener(this.lstBlocks){

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
                MobileBlocksPanel.this.dropEnabled = false;
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                MobileBlocksPanel.this.dropEnabled = true;
            }
        };
    }

    public void setKeys(JFrame frame) {
        InputMap inputMap = frame.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "test");
        ActionMap actionMap = frame.getRootPane().getActionMap();
        actionMap.put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileBlocksPanel.this.delete();
            }
        });
        actionMap.put("test", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileBlocksPanel.this.test();
            }
        });
    }

    private void test() {
        int[] indiciesOrdered = this.lstBlocks.getOrderedIndicies();
        if (indiciesOrdered != null) {
            for (int x = 0; x < indiciesOrdered.length; ++x) {
                System.out.println(indiciesOrdered[x]);
            }
        }
    }

    private void initComponents() {
        this.dockPanel = new DockPanel(){
            int wd;
            int ht;

            @Override
            public boolean beforeDock() {
                this.ht = this.getHeight();
                this.wd = this.getWidth();
                return true;
            }

            @Override
            public void afterUndocked() {
                Frame win = this.getParentWindow();
                if (win != null) {
                    win.setSize(this.wd, this.ht);
                }
            }
        };
        this.cmdDelete = new GlossyButton();
        this.cmdSave = new GlossyButton();
        this.cmdSaveAs = new GlossyButton();
        this.jScrollPane3 = new JScrollPane();
        this.lstBlocks = new IconListBox();
        this.statusLabel = new StatusLabel();
        this.editor = new SequenceEditorPanel();
        this.jLabel1 = new JLabel();
        this.cmdOpen = new GlossyButton();
        this.lblHelp = new JLabel();
        this.dockPanel.setIcon(new ImageIcon(this.getClass().getResource("/images24/Arrow2.png")));
        this.dockPanel.setShowMaxButton(false);
        this.dockPanel.setShowMinButton(false);
        this.dockPanel.setTitle("pLOT - Sequence Blocks");
        this.cmdDelete.setIcon(new ImageIcon(this.getClass().getResource("/images24/X.png")));
        this.cmdDelete.setText("Delete");
        this.cmdDelete.setToolTipText("Remove selected item");
        this.cmdDelete.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdDelete.setEnabled(false);
        this.cmdDelete.setShiftOnPress(true);
        this.cmdDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobileBlocksPanel.this.cmdDeleteActionPerformed(evt);
            }
        });
        this.cmdSave.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdSave.setText("Save");
        this.cmdSave.setToolTipText("Save list to disk");
        this.cmdSave.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdSave.setShiftOnPress(true);
        this.cmdSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobileBlocksPanel.this.cmdSaveActionPerformed(evt);
            }
        });
        this.cmdSaveAs.setIcon(new ImageIcon(this.getClass().getResource("/images24/Save2.png")));
        this.cmdSaveAs.setText("Save as");
        this.cmdSaveAs.setToolTipText("Save to a different file");
        this.cmdSaveAs.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdSaveAs.setShiftOnPress(true);
        this.cmdSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobileBlocksPanel.this.cmdSaveAsActionPerformed(evt);
            }
        });
        this.lstBlocks.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MobileBlocksPanel.this.lstBlocksValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstBlocks);
        this.statusLabel.setIcon(new ImageIcon(this.getClass().getResource("/images16/ToHeadlessArrow.png")));
        GroupLayout statusLabelLayout = new GroupLayout(this.statusLabel);
        this.statusLabel.setLayout(statusLabelLayout);
        statusLabelLayout.setHorizontalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        statusLabelLayout.setVerticalGroup(statusLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.editor.setAutoColumnCount(true);
        this.editor.setEditable(false);
        this.jLabel1.setText("Sequence Preview");
        this.cmdOpen.setIcon(new ImageIcon(this.getClass().getResource("/images24/Open.png")));
        this.cmdOpen.setText("Open");
        this.cmdOpen.setToolTipText("Open a saved file from disk");
        this.cmdOpen.setButtonStyle(ButtonRenderer.ButtonStyle.Galaxy);
        this.cmdOpen.setShiftOnPress(true);
        this.cmdOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MobileBlocksPanel.this.cmdOpenActionPerformed(evt);
            }
        });
        this.lblHelp.setHorizontalAlignment(0);
        this.lblHelp.setIcon(new ImageIcon(this.getClass().getResource("/images24/QUESTION.png")));
        GroupLayout dockPanelLayout = new GroupLayout(this.dockPanel.getContentPane());
        this.dockPanel.getContentPane().setLayout(dockPanelLayout);
        dockPanelLayout.setHorizontalGroup(dockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dockPanelLayout.createSequentialGroup().addContainerGap().addGroup(dockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel, -1, 348, Short.MAX_VALUE).addComponent(this.editor, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, dockPanelLayout.createSequentialGroup().addComponent(this.jScrollPane3, -1, 284, Short.MAX_VALUE).addGroup(dockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dockPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(dockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdSaveAs, GroupLayout.Alignment.TRAILING, -2, 58, -2).addComponent(this.cmdSave, GroupLayout.Alignment.TRAILING, -2, 58, -2).addComponent(this.cmdOpen, GroupLayout.Alignment.TRAILING, -2, 58, -2).addComponent(this.cmdDelete, GroupLayout.Alignment.TRAILING, -2, 58, -2))).addGroup(dockPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.lblHelp, -2, 32, -2)))).addGroup(dockPanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 116, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        dockPanelLayout.setVerticalGroup(dockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, dockPanelLayout.createSequentialGroup().addContainerGap().addGroup(dockPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dockPanelLayout.createSequentialGroup().addComponent(this.cmdDelete, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdOpen, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdSave, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdSaveAs, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHelp).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane3, -1, 283, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addGap(4, 4, 4).addComponent(this.editor, -1, 154, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.statusLabel, -2, -1, -2).addGap(0, 0, 0)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.dockPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.dockPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void cmdDeleteActionPerformed(ActionEvent evt) {
        this.delete();
    }

    public void delete() {
        int[] indicies = this.lstBlocks.getSelectedIndices();
        if (indicies.length > 0) {
            int cIndex = indicies.length == 1 ? indicies[0] : this.lstBlocks.getSelectedIndex();
            for (int x = indicies.length - 1; x >= 0; --x) {
                if (indicies[x] <= -1) continue;
                this.lstBlocks.removeItem(indicies[x]);
            }
            if (cIndex < this.lstBlocks.getItemCount() && cIndex > 0) {
                this.lstBlocks.setSelectedIndex(cIndex);
            } else if (this.lstBlocks.getItemCount() > 0) {
                this.lstBlocks.setSelectedIndex(this.lstBlocks.getItemCount() - 1);
            }
        }
    }

    private void cmdSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void open(File file) {
        this.lstBlocks.clear();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            SequenceExportFormat[] blocks = (SequenceExportFormat[])objectInputStream.readObject();
            for (int x = 0; x < blocks.length; ++x) {
                this.lstBlocks.addItem(new MobileBlock(blocks[x]));
            }
            this.currentFile = file;
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(MobileBlocksPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void save() {
        if (this.currentFile == null) {
            this.saveAs();
        } else {
            try {
                int count = this.lstBlocks.getModel().getSize();
                SequenceExportFormat[] blocks = new SequenceExportFormat[count];
                for (int x = 0; x < count; ++x) {
                    blocks[x] = (SequenceExportFormat)this.lstBlocks.getItem(x).getItem();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.currentFile);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(blocks);
                objectOutputStream.flush();
                objectOutputStream.close();
                this.statusLabel.setText("Saved to: " + this.currentFile.getAbsolutePath());
            }
            catch (IOException ex) {
                Logger.getLogger(MobileBlocksPanel.class.getName()).log(Level.SEVERE, null, ex);
                this.statusLabel.setText("Save failed!");
            }
        }
    }

    private void open() {
        int val;
        JFileChooser c = new JFileChooser();
        c.setFileFilter(FileDialog.GenerateFilter("pLOT Sequence Blocks File", ".blocks"));
        if (this.currentFile != null) {
            c.setSelectedFile(this.currentFile);
        }
        if ((val = c.showOpenDialog(this.dockPanel.getParentWindow())) != 0) {
            return;
        }
        File file = c.getSelectedFile();
        if (file != null && file.getName().toLowerCase().endsWith(".blocks")) {
            this.open(file);
        }
    }

    private void saveAs() {
        JFileChooser c = new JFileChooser();
        c.setFileFilter(FileDialog.GenerateFilter("pLOT Sequence Blocks File", ".blocks"));
        int val = c.showSaveDialog(this.dockPanel.getParentWindow());
        if (val != 0) {
            return;
        }
        File file = c.getSelectedFile();
        if (file != null) {
            if (!file.getName().toLowerCase().endsWith(".blocks")) {
                file = new File(file.getAbsoluteFile() + ".blocks");
            }
            this.currentFile = file;
            this.save();
        }
    }

    private void cmdSaveAsActionPerformed(ActionEvent evt) {
        this.saveAs();
    }

    private void updateEnables() {
        boolean enabled = this.lstBlocks.getSelectedIndex() > -1;
        this.cmdDelete.setEnabled(enabled);
    }

    private void lstBlocksValueChanged(ListSelectionEvent evt) {
        Object item;
        int selIndex;
        this.editor.clear();
        if (this.lstBlocks.getModel().getSize() > 0 && (selIndex = this.lstBlocks.getSelectedIndex()) > -1 && (item = this.lstBlocks.getItem(this.lstBlocks.getSelectedIndex()).getItem()) != null) {
            SequenceExportFormat sef = (SequenceExportFormat)item;
            this.editor.getDocument().setSequence(sef);
            this.editor.select(0);
            this.editor.setSelectionLength(0);
        }
        this.updateEnables();
    }

    private void cmdOpenActionPerformed(ActionEvent evt) {
        this.open();
    }
}

