/*
 * Decompiled with CFR 0.152.
 */
package plot;

import java.util.ArrayList;
import java.util.Comparator;
import plot.Cluster;
import plot.SpacedObject;

class ObjectSpacer {
    private static int min = 0;
    private static int max = 0;
    private static Cluster root;
    private static Cluster last;
    private static int count;
    public static final int NONE = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    static Comparator ascendingSort;
    static Comparator descendingSort;

    ObjectSpacer() {
    }

    public static void clearList() {
        if (root != null) {
            last = null;
        }
        if (root != null) {
            root.clear();
            root = null;
        }
        last = null;
        count = 0;
    }

    public static void setMinMax(int newMin, int newMax) {
        min = newMin;
        max = newMax;
    }

    public static void add(SpacedObject o) {
        Cluster c = new Cluster(o);
        if (root == null) {
            last = root = c;
        } else {
            ObjectSpacer.last.nextCluster = c;
            c.prevCluster = last;
            last = c;
        }
        ++count;
    }

    public static int getItemCount() {
        return count;
    }

    public static void spaceObjects() {
        ObjectSpacer.spaceClusters(root, min, max);
    }

    public static void spaceObjects(int min, int max) {
        ObjectSpacer.spaceClusters(root, min, max);
    }

    public static void spaceObjects(ArrayList<SpacedObject> list, int minDist, int maxDist, int sortType) {
        if (list == null || list.isEmpty()) {
            return;
        }
        switch (sortType) {
            case 1: {
                list.sort(ascendingSort);
                break;
            }
            case 2: {
                list.sort(descendingSort);
            }
        }
        ObjectSpacer.spaceClusters(ObjectSpacer.getClusterChain(list), minDist, maxDist);
    }

    private static Cluster getClusterChain(ArrayList<SpacedObject> list) {
        Cluster outRoot = new Cluster(list.get(0));
        Cluster current = root;
        for (int x = 1; x < list.size(); ++x) {
            Cluster.link(root, new Cluster(list.get(x)));
            current = current.nextCluster;
        }
        return outRoot;
    }

    private static void spaceClusters(Cluster root, int minDist, int maxDist) {
        boolean shiftedClusters = false;
        Cluster curr = root;
        while (curr != null) {
            if (curr.min < minDist) {
                curr.min = minDist;
            } else if (curr.getMax() > maxDist) {
                curr.min = maxDist - curr.size;
            }
            if (curr.nextCluster != null) {
                if (curr.nextCluster.min < minDist) {
                    curr.nextCluster.min = minDist;
                } else if (curr.nextCluster.getMax() > maxDist) {
                    curr.nextCluster.min = maxDist - curr.nextCluster.size;
                }
                if (curr.getMax() > curr.nextCluster.min) {
                    shiftedClusters = true;
                    int midX = (curr.min + curr.nextCluster.getMax()) / 2;
                    curr.append(curr.nextCluster);
                    curr.min = Math.min(Math.max(midX - curr.size / 2, minDist), max - curr.size);
                }
            }
            curr = curr.nextCluster;
        }
        if (shiftedClusters) {
            ObjectSpacer.spaceClusters(root, minDist, maxDist);
        } else {
            curr = root;
            while (curr != null) {
                curr.commitDistances();
                curr = curr.nextCluster;
            }
        }
    }

    static {
        count = 0;
        ascendingSort = (o1, o2) -> {
            int s2;
            SpacedObject f1 = (SpacedObject)o1;
            SpacedObject f2 = (SpacedObject)o2;
            int s1 = f1.getSortValue();
            if (s1 < (s2 = f2.getSortValue())) {
                return -1;
            }
            if (s1 > s2) {
                return 1;
            }
            return 0;
        };
        descendingSort = (o1, o2) -> {
            int s2;
            SpacedObject f1 = (SpacedObject)o1;
            SpacedObject f2 = (SpacedObject)o2;
            int s1 = f1.getSortValue();
            if (s1 > (s2 = f2.getSortValue())) {
                return -1;
            }
            if (s1 < s2) {
                return 1;
            }
            return 0;
        };
    }
}

