/*
 * Decompiled with CFR 0.152.
 */
package plot;

import FileConverters.ImpFileReader;
import FileConverters.ImpFileWriter;
import GenbankFileReader.GenBankFile;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import Sequences.DNA;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import plot.DefaultConverter;
import plot.EnzymeFilter;
import plot.EnzymeMix;
import plot.Feature;
import plot.ProjectDocument;
import plot.ProjectEnzyme;

class PlotFileConverter
implements ImpFileReader,
ImpFileWriter,
DefaultConverter {
    protected String error = null;
    private static String[] extensions = new String[]{"plt"};

    PlotFileConverter() {
    }

    @Override
    public int getSortOrder() {
        return 0;
    }

    @Override
    public String[] getReadFileExtensions() {
        return extensions;
    }

    @Override
    public String getReadFormatDescription() {
        return "pLOT File";
    }

    @Override
    public String getReadError() {
        return this.error;
    }

    @Override
    public GenBankFile loadFile(File file) {
        return GenBankFile.loadGBFile(file);
    }

    @Override
    public boolean acceptFileForRead(File file) {
        String lc = file.getAbsolutePath().toLowerCase();
        return lc.endsWith("plt");
    }

    @Override
    public String getWriteFileExtension() {
        return "plt";
    }

    @Override
    public String getWriteFormatDescription() {
        return "pLOT Genbank Format";
    }

    @Override
    public String getWriteError() {
        return this.error != null ? this.error : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File write(File dest, ProjectDocument project) {
        if (!(!dest.exists() || dest.isFile() && dest.canWrite())) {
            return null;
        }
        BufferedWriter writer = null;
        try {
            FileWriter fw = new FileWriter(dest);
            writer = new BufferedWriter(fw);
            writer.write(project.toGBString());
            int count = project.getReferenceCount();
            if (count > 0) {
                for (int x = 0; x < count; ++x) {
                    writer.write("\n" + project.getReference(x).toGBString(x));
                }
            }
            if (project.getSelectedEnzymesCount() > 0) {
                for (ProjectEnzyme projectEnzyme : project.selectedEnzymes) {
                    writer.write("\nCOMMENT ENZYME = " + projectEnzyme.enzyme.getName());
                }
            }
            if (project.getEnzymeMixCount() > 0) {
                for (EnzymeMix enzymeMix : project.enzymeMixes) {
                    writer.write("\n" + enzymeMix.toGBString());
                }
            }
            if (project.getEnzymeFilterCount() > 0) {
                for (EnzymeFilter enzymeFilter : project.enzymeFilters) {
                    writer.write("\n" + enzymeFilter.toGBString());
                }
            }
            writer.write("\nFEATURES             Location/Qualifiers");
            ExtensibleArray<ROI> features = project.getFeatures();
            if (!features.isEmpty()) {
                for (ROI roi : features) {
                    Feature f = (Feature)roi;
                    writer.write("\n" + f.toGBString());
                }
            }
            writer.write("\nORIGIN\n");
            writer.write(DNA.getFormattedSequence(project.getSequence(), 10));
            writer.write("//");
            writer.close();
            File file = dest;
            return file;
        }
        catch (IOException ex) {
            this.error = "Save error: " + ex.getLocalizedMessage();
            File file = null;
            return file;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                this.error = "Writter close error: " + iOException.getLocalizedMessage();
                return null;
            }
        }
    }
}

