/*
 * Decompiled with CFR 0.152.
 */
package plot;

import BinaryTrees.BinaryChain;
import GenbankFileReader.Annotation;
import GenbankFileReader.GenBankFile;
import GenbankFileReader.Locus;
import GenbankFileReader.Qualifier;
import GenbankFileReader.Reference;
import MiscTools.ColorTools;
import SequenceEditorPanels.Base;
import SequenceEditorPanels.DNASequenceDocument;
import SequenceEditorPanels.ExtensibleArray;
import SequenceEditorPanels.ROI;
import SequenceEditorPanels.SequenceDocumentChangeListener;
import Sequences.DNA;
import Sequences.SequenceExportFormat;
import ToolTip.BasicTextToolTip;
import UndoRedo.ChangeEvent;
import UndoRedo.Undoable;
import UndoRedo.UndoableAction;
import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import plot.Circle;
import plot.DefaultLibraries;
import plot.EnzymeFeature;
import plot.EnzymeFilter;
import plot.EnzymeMix;
import plot.Feature;
import plot.PrimerCategory;
import plot.PrimerFeature;
import plot.ProjectEnzyme;

public class ProjectDocument
extends DNASequenceDocument {
    public static final int PROPERTY_RESET = 103;
    public static final int PROPERTY_FILE = 104;
    public static final int PROPERTY_SELECTED_FEATURE = 105;
    public static final int PROPERTY_REDRAW_NEEDED = 106;
    public static final int PROPERTY_REDRAW_GEL = 107;
    public static final int PROPERTY_SELECTION_CHANGE = 108;
    public static final int PROPERTY_NOTES_CHANGED = 109;
    public static final int PROPERTY_FIND_PRIMERS = 110;
    public static final int PROPERTY_FIND_ENZYMES = 111;
    public static final int PROPERTY_DISPLAY_SELECTED_ITEM = 112;
    public static final int PROPERTY_UPDATE_SELECTION_PROPERTIES = 113;
    public static final int PROPERTY_UPDATE_MENU_ACCESS = 114;
    public static final int PROPERTY_CLEAR_SELECTION = 115;
    public static final int PROPERTY_DOCUMENT_UPDATED = 116;
    public static final int PROPERTY_FIND_ENZYMES_AND_PRIMERS = 117;
    public static final int TYPE_FEATURE = 0;
    public static final int TYPE_PRIMERFEATURE = 1;
    public static final int TYPE_ENZYMEFEATURE = 2;
    public static final int TYPE_EMPTY = -1;
    static Color primerColor = Color.GREEN.darker().darker();
    static Color ttPrimerColor = BasicTextToolTip.TOOLTIP_GREEN;
    static Color ttCDSColor = BasicTextToolTip.TOOLTIP_BLUE;
    static Color ttGeneralColor = BasicTextToolTip.TOOLTIP_YELLOW;
    static final double PI2 = Math.PI * 2;
    int centerLinY = 0;
    Circle pCircle;
    Circle lCircle;
    Circle jCircle;
    int mapWd = 0;
    int mapHt = 0;
    int xOffset = 0;
    int yOffset = 0;
    double box_Height = 30.0;
    double pointHeight = 10.0;
    Feature selectedItem;
    ArrayList<Feature> selectedItems = new ArrayList();
    Feature mouseoverItem;
    String dataType = "DNA";
    private transient File file = null;
    transient boolean labelsCircular = false;
    transient float zoomFactor = 1.0f;
    double radianPerBp = 0.0;
    double degreesPerBp = 0.0;
    double pixPerBp = 0.0;
    boolean isLabelChanged = false;
    boolean isSequenceChanged = false;
    boolean isFeatureChanged = false;
    boolean needPaths = false;
    ArrayList<PrimerFeature> foundPrimers = new ArrayList();
    final BinaryChain<ProjectEnzyme> defaultEnzymes = new BinaryChain();
    ArrayList<EnzymeFeature> foundEnzymes = new ArrayList();
    BinaryChain<ProjectEnzyme> selectedEnzymes = new BinaryChain();
    BinaryChain<EnzymeMix> enzymeMixes = new BinaryChain();
    ExtensibleArray<EnzymeFilter> enzymeFilters = new ExtensibleArray<EnzymeFilter>(EnzymeFilter.class);
    BinaryChain<PrimerCategory> foundCategories = new BinaryChain();
    final PrimerCategory catNoCategory = new PrimerCategory(" [No Category] ");
    boolean showPrimers = false;
    boolean showUserPrimers = true;
    boolean showDefaultPrimers = true;
    boolean showEnzymes = false;
    boolean showLabels = true;
    final BinaryChain<EnzymeFeature[]> linkedEnzymes = new BinaryChain();
    final BinaryChain<PrimerFeature[]> linkedPrimers = new BinaryChain();
    private static final String MIXHEADER = "COMMENT ENZMIX = [";
    static final ChangeEvent[] restorePointEvents = new ChangeEvent[]{new ChangeEvent(0), new ChangeEvent(3), new ChangeEvent(1), new ChangeEvent(2), new ChangeEvent(4), new ChangeEvent(108), new ChangeEvent(6), new ChangeEvent(106), new ChangeEvent(107), new ChangeEvent(10)};

    static Color getPrimerColor() {
        return primerColor;
    }

    static Color getToolTipPrimerColor() {
        return ttPrimerColor;
    }

    static Color getToolTipCDSColor() {
        return ttCDSColor;
    }

    static Color getToolTipDefaultColor() {
        return ttGeneralColor;
    }

    ExtensibleArray<Base> getSequenceBases() {
        return this.sequence;
    }

    public int getSelectedEnzymesCount() {
        return this.selectedEnzymes.size();
    }

    public int getEnzymeMixCount() {
        return this.enzymeMixes.size();
    }

    public void clearEnzymeFilters() {
        this.enzymeFilters.clear();
    }

    public void clearSelectedEnzymes() {
        this.selectedEnzymes.clear();
    }

    public void clearROIs() {
        this.features.clear();
    }

    public int getEnzymeFilterCount() {
        return this.enzymeFilters.size();
    }

    public ProjectDocument() {
        this.initDoc();
    }

    public ProjectDocument(SequenceDocumentChangeListener l) {
        this.initDoc();
        this.addListener(l);
    }

    private void initDoc() {
        DefaultLibraries.initEnzymes(this);
    }

    public Feature getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setAccession(String accession) {
        super.setAccession(accession);
    }

    void setAccession(String accession, boolean update) {
        if (update) {
            super.setAccession(accession);
        } else {
            this.accession = accession;
        }
    }

    public Feature[] getSelectedItems() {
        if (this.selectedItem == null || this.selectedItems.isEmpty()) {
            return null;
        }
        Feature[] outFeatures = new Feature[this.selectedItems.size()];
        for (int x = 0; x < this.selectedItems.size(); ++x) {
            outFeatures[x] = this.selectedItems.get(x);
        }
        return outFeatures;
    }

    public Feature[] getSelectedItems(int featureType) {
        if (this.selectedItem == null || this.selectedItems.isEmpty()) {
            return null;
        }
        Feature first = this.selectedItems.get(0);
        if (first instanceof PrimerFeature) {
            if (featureType != 1) {
                return null;
            }
        } else if (first instanceof EnzymeFeature) {
            if (featureType != 2) {
                return null;
            }
        } else if (first instanceof Feature) {
            if (featureType != 0) {
                return null;
            }
        } else {
            return null;
        }
        Feature[] outFeatures = new Feature[this.selectedItems.size()];
        outFeatures[0] = first;
        for (int x = 1; x < this.selectedItems.size(); ++x) {
            outFeatures[x] = this.selectedItems.get(x);
        }
        return outFeatures;
    }

    public int getSelectedItemsType() {
        if (this.selectedItem == null || this.selectedItems.isEmpty()) {
            return -1;
        }
        Feature first = this.selectedItems.get(0);
        if (first instanceof PrimerFeature) {
            return 1;
        }
        if (first instanceof EnzymeFeature) {
            return 2;
        }
        if (first instanceof Feature) {
            return 0;
        }
        return -1;
    }

    public boolean hasSelectedItemType(int featureType) {
        if (this.selectedItem == null || this.selectedItems.isEmpty()) {
            return false;
        }
        Feature first = this.selectedItems.get(0);
        if (first instanceof PrimerFeature) {
            return featureType == 1;
        }
        if (first instanceof EnzymeFeature) {
            return featureType == 2;
        }
        if (first instanceof Feature) {
            return featureType == 0;
        }
        return false;
    }

    public void setSelectedItem(Feature feature) {
        this.setSelectedItem(feature, true);
    }

    public void setSelectedItem(Feature feature, boolean notify) {
        this.selectedItem = feature;
        this.selectedItems.clear();
        if (feature == null) {
            if (notify) {
                this.fireEvents(new ChangeEvent(108, 106));
            }
        } else if (!this.selectedItems.contains(feature)) {
            this.selectedItems.add(feature);
            if (notify) {
                this.fireEvents(new ChangeEvent(108, 106));
            }
        } else {
            this.selectedItems.remove(feature);
            if (this.selectedItem == feature) {
                this.selectedItem = !this.selectedItems.isEmpty() ? this.selectedItems.get(this.selectedItems.size() - 1) : null;
            }
            if (notify) {
                this.fireEvents(new ChangeEvent(108, 106));
            }
        }
    }

    public void addSelectedItem(Feature feature) {
        this.addSelectedItem(feature, true);
    }

    public void addSelectedItem(Feature feature, boolean notify) {
        if (feature == null || this.selectedItems.isEmpty() || !feature.getClass().equals(this.selectedItems.get(0).getClass())) {
            this.setSelectedItem(feature, notify);
        } else if (!this.selectedItems.contains(feature)) {
            this.selectedItems.add(feature);
            this.selectedItem = feature;
            if (notify) {
                this.fireEvents(new ChangeEvent(108, 106));
            }
        }
    }

    @Override
    public boolean antisense() {
        if (ProjectDocument.main_AntisenseSeq(this.sequence)) {
            ProjectDocument.main_AntisenseFeatures(this.features, this.sequence.size());
            this.main_AntisenseFeature_EP();
            this.fireEvents(new ChangeEvent(10), new ChangeEvent(106));
            return true;
        }
        return false;
    }

    protected void main_AntisenseFeature_EP() {
        int seqLen = this.length();
        if (!this.foundPrimers.isEmpty()) {
            for (PrimerFeature primerFeature : this.foundPrimers) {
                primerFeature.antisense(seqLen);
            }
        }
        if (!this.foundEnzymes.isEmpty()) {
            for (EnzymeFeature enzymeFeature : this.foundEnzymes) {
                enzymeFeature.antisense(seqLen);
            }
        }
        if (!this.defaultEnzymes.isEmpty()) {
            for (ProjectEnzyme projectEnzyme : this.defaultEnzymes) {
                if (projectEnzyme.getCutCount() <= 0) continue;
                for (Locus locus : projectEnzyme.cuts) {
                    locus.antisense(seqLen);
                }
            }
        }
    }

    public ProjectDocument clone() {
        ProjectDocument clone = new ProjectDocument();
        clone.cloneFrom(this);
        clone.file = this.file;
        return clone;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        this.fireEvents(new ChangeEvent(104, oldFile != null ? oldFile.getAbsolutePath() : "", file != null ? file.getAbsolutePath() : ""));
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.file != null ? this.file.getAbsolutePath() : "";
    }

    void addFoundEnzyme(ProjectEnzyme e) {
        if (e != null && e.getCutCount() > 0) {
            ExtensibleArray<EnzymeFeature> list = new ExtensibleArray<EnzymeFeature>(EnzymeFeature.class);
            for (int x = 0; x < e.getCutCount(); ++x) {
                EnzymeFeature f = new EnzymeFeature(e, x);
                list.add(f);
                this.foundEnzymes.add(f);
            }
            this.linkedEnzymes.add(list.toArray(), e.enzyme.name);
        }
    }

    public void reset() {
        this.file = null;
        this.dataType = "DNA";
        this.zoomFactor = 1.0f;
        this.notes = "";
        this.setName("");
        this.organism = "";
        this.source = "";
        this.accession = "";
        this.setChanged(false);
        this.isLabelChanged = false;
        this.isSequenceChanged = false;
        this.isFeatureChanged = false;
        this.features.clear();
        this.sequence.clear();
        this.selectedItems.clear();
        this.mouseoverItem = null;
        this.selectedEnzymes.clear();
        this.foundEnzymes.clear();
        this.foundPrimers.clear();
        this.selectedEnzymes.clear();
        this.enzymeMixes.clear();
        this.enzymeFilters.clear();
        this.fireEvents(new ChangeEvent(103), new ChangeEvent(114));
    }

    void calcRadians() {
        int length = this.length();
        this.radianPerBp = Math.PI * 2 / (double)length;
        this.degreesPerBp = (double)length / 360.0;
        this.pixPerBp = ((float)this.mapWd - 20.0f) / (float)length;
    }

    int bpToX(double bp) {
        return (int)((bp - 1.0) / ((double)this.length() - 1.0) * ((double)this.mapWd - 20.0) + 10.0);
    }

    @Override
    public void setSequence(SequenceExportFormat data) {
        this.setSequence(data, true, true);
    }

    public void setSequence(SequenceExportFormat data, boolean clearEnzymes, boolean clearPrimers) {
        if (!this.setSequence(data.sequence)) {
            return;
        }
        this.name = data.name;
        if (data.hasQualifiers()) {
            for (Qualifier qualifier : data.qualifiers) {
                if (qualifier.key.equals("source")) {
                    this.source = qualifier.value;
                    continue;
                }
                if (!qualifier.key.equals("organism")) continue;
                this.organism = qualifier.value;
            }
        }
        this.circular = data.circular;
        this.selectedItems.clear();
        this.mouseoverItem = null;
        if (clearEnzymes) {
            this.foundEnzymes.clear();
        }
        if (clearPrimers) {
            this.foundPrimers.clear();
        }
        if (data.annotations != null) {
            for (Serializable serializable : data.annotations) {
                this.features.add(Feature.fromAnnotation((Annotation)serializable));
            }
        }
        if (this.isListenerActive()) {
            this.fireEvents(new ChangeEvent(106), new ChangeEvent(10));
        }
    }

    @Override
    public boolean setOrigin(int newOrigin) {
        boolean enabled = this.disableListeners();
        if (!super.setOrigin(newOrigin)) {
            this.listenersEnabled = enabled;
            return false;
        }
        int seqLen = this.length();
        if (!this.foundPrimers.isEmpty()) {
            for (PrimerFeature primerFeature : this.foundPrimers) {
                primerFeature.rotateOrigin(newOrigin, seqLen);
            }
        }
        if (!this.foundEnzymes.isEmpty()) {
            for (EnzymeFeature enzymeFeature : this.foundEnzymes) {
                enzymeFeature.rotateOrigin(newOrigin, seqLen);
            }
        }
        if (!this.defaultEnzymes.isEmpty()) {
            for (ProjectEnzyme projectEnzyme : this.defaultEnzymes) {
                if (projectEnzyme.getCutCount() <= 0) continue;
                for (Locus locus : projectEnzyme.cuts) {
                    locus.rotateOrigin(newOrigin, seqLen);
                }
            }
        }
        if (this.isListenerActive()) {
            this.fireEvents(new ChangeEvent(10), new ChangeEvent(106));
        }
        this.listenersEnabled = enabled;
        return true;
    }

    @Override
    public boolean antisense(int start, int stop) {
        if (super.antisense(start, stop)) {
            int seqLen = this.length();
            if (!this.foundPrimers.isEmpty()) {
                for (PrimerFeature p : this.foundPrimers) {
                    p.antisense(seqLen);
                }
            }
            if (!this.foundEnzymes.isEmpty()) {
                for (EnzymeFeature e : this.foundEnzymes) {
                    e.antisense(seqLen);
                }
            }
            return true;
        }
        return false;
    }

    public String toGBString() {
        StringBuilder sb = new StringBuilder();
        String date = new SimpleDateFormat("MM-dd-yyyy").format(new Date(System.currentTimeMillis()));
        sb.append("LOCUS        ").append(this.getName()).append("        ").append(this.length()).append(" bp       ").append(this.dataType).append("        ").append(this.isCircular() ? "circular      " : "linear      ").append(date).append("\nACCESSION    ").append(this.accession != null && this.accession.length() > 0 ? this.accession : ".").append("\nSOURCE       ").append(this.source).append("\nORGANISM     ").append(this.organism).append("\nCOMMENT pLOT_File_Version 2.1").append("\nCOMMENT Plasmid Name: ").append(this.getName()).append("\nCOMMENT Project Codon Table = ").append(this.codonTable.getOrganismName());
        if (this.notes != null && this.notes.length() > 0) {
            String[] noteLines = this.notes.split("\n");
            for (int x = 0; x < noteLines.length; ++x) {
                sb.append("\nCOMMENT Note: ").append(noteLines[x]);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean delete(int bpStart, int bpStop) {
        if (super.delete(bpStart, bpStop)) {
            this.setChanged(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean insert(int bpPosition, String seq) {
        if (super.insert(bpPosition, seq)) {
            this.setChanged(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean insert(int bpPosition, SequenceExportFormat sef) {
        if (sef == null || sef.sequence.length() == 0) {
            return false;
        }
        if (this.insertFiltered(bpPosition, sef.sequence.toCharArray())) {
            if (sef.annotations != null) {
                for (ROI roi : sef.annotations) {
                    roi.setStart(roi.getStart() + bpPosition - 1);
                    roi.setStop(roi.getStop() + bpPosition - 1);
                    this.features.add(Feature.fromAnnotation(roi));
                }
            }
            return true;
        }
        return false;
    }

    public void cloneFromGenbankFile(GenBankFile src) {
        ProjectDocument.fromGenbankFile(src, this);
    }

    public static ProjectDocument fromDNASequenceDocument(DNASequenceDocument src) {
        if (src instanceof ProjectDocument) {
            ProjectDocument retDoc = ((ProjectDocument)src).clone();
            return retDoc;
        }
        ProjectDocument dest = new ProjectDocument();
        ProjectDocument.fromDNASequenceDocument(src, dest);
        return dest;
    }

    public void cloneFrom(ProjectDocument src) {
        this.reset();
        this.name = src.name;
        this.organism = src.organism;
        this.accession = src.accession;
        this.dataType = src.dataType;
        this.baseOffset = src.baseOffset;
        this.notes = src.notes;
        this.codonTable.setOrganism(src.getCodonTableIndex());
        this.circular = src.circular;
        this.setSequence(src.getSequence());
        if (!src.enzymeMixes.isEmpty()) {
            for (EnzymeFilter ef : src.enzymeFilters) {
                this.enzymeFilters.add(ef.clone());
            }
        }
        if (!src.features.isEmpty()) {
            for (ROI roi : src.features) {
                if (roi instanceof Feature) {
                    Feature feature = (Feature)roi;
                    this.features.add(feature.clone());
                    continue;
                }
                this.features.add(Feature.fromAnnotation(roi));
            }
        }
        if (!src.selectedEnzymes.isEmpty()) {
            for (ProjectEnzyme e : src.selectedEnzymes) {
                this.selectedEnzymes.add(e.clone());
            }
        }
        if (!src.qualifiers.isEmpty()) {
            for (Qualifier q : src.qualifiers) {
                this.qualifiers.add(q.clone());
            }
        }
        if (!src.references.isEmpty()) {
            for (Reference r : src.references) {
                this.references.add(r.clone());
            }
        }
    }

    ExtensibleArray<ROI> getFeatures() {
        return this.getFeaturesArray();
    }

    void setNotes(String text, boolean update) {
        if (update) {
            super.setNotes(text);
        } else {
            this.notes = text != null ? text : "";
        }
    }

    void setSource(String source, boolean update) {
        if (update) {
            super.setSource(source);
        } else {
            this.main_setSrc(source);
        }
    }

    void setOrganism(String org, boolean update) {
        if (update) {
            super.setOrganism(org);
        } else {
            this.organism = org;
        }
    }

    private static void fromDNASequenceDocument(DNASequenceDocument src, ProjectDocument dest) {
        int qCount;
        dest.name = src.getName();
        dest.circular = src.isCircular();
        dest.setSequence(src.getSequence());
        dest.setCodonTable(src.getCodonTableIndex());
        dest.setSource(src.getSource());
        int len = dest.length();
        int max = src.getFeatureCount();
        for (int x = 0; x < max; ++x) {
            ROI roi = src.getROI(x);
            if (roi.getStart() <= 0 || roi.getStop() > len) continue;
            Feature feature = Feature.fromAnnotation(roi);
            if (feature.getName().length() == 0) {
                roi.setName("New Feature " + (dest.features.size() + 1));
            }
            dest.features.add(feature);
        }
        int refCount = src.getReferenceCount();
        if (refCount > 0) {
            for (int x = 0; x < refCount; ++x) {
                dest.references.add(src.getReference(x).clone());
            }
        }
        if ((qCount = src.getQualifiersCount()) > 0) {
            for (int x = 0; x < qCount; ++x) {
                dest.qualifiers.add(src.getQualifier(x).clone());
            }
        }
    }

    public static ProjectDocument fromGenbank(GenBankFile src) {
        ProjectDocument dest = new ProjectDocument();
        ProjectDocument.fromGenbankFile(src, dest);
        return dest;
    }

    public Feature getFeature(int index) {
        ROI roi = (ROI)this.features.get(index);
        return roi != null ? (Feature)roi : null;
    }

    public static void fromGenbankFile(GenBankFile src, ProjectDocument dest) {
        if (src != null) {
            String seq = DNA.filterSequence(src.getSequence());
            int seqLen = seq.length();
            if (seqLen == 0) {
                return;
            }
            dest.name = src.getName();
            dest.circular = src.isCircular();
            dest.notes = src.header.notes;
            dest.setSequence(seq);
            if (src.header.qualifiers != null && src.header.qualifiers.length > 0) {
                for (Qualifier qualifier : src.header.qualifiers) {
                    EnzymeFilter filter;
                    if (qualifier.key.equalsIgnoreCase("codon_table")) {
                        dest.setOrganism(qualifier.value);
                        continue;
                    }
                    if (qualifier.key.equalsIgnoreCase("ENZYME")) {
                        dest.addEnzyme(qualifier.value);
                        continue;
                    }
                    if (qualifier.key.equalsIgnoreCase("ENZMIX")) {
                        EnzymeMix mix = ProjectDocument.fromEnzymeNames(dest, qualifier.value);
                        if (mix == null) continue;
                        dest.enzymeMixes.add(mix);
                        continue;
                    }
                    if (!qualifier.key.equalsIgnoreCase("RE_Filter") || (filter = EnzymeFilter.fromValues(dest, qualifier.value.split("\t"))) == null) continue;
                    dest.enzymeFilters.add(filter);
                }
            }
            for (Annotation feature : src.features) {
                if (feature.getStart() <= 0 || feature.getStart() > seqLen || feature.getStop() <= 0 || feature.getStop() > seqLen) continue;
                ROI roi = ROI.fromAnnotation(feature);
                if (roi.getName().length() == 0) {
                    roi.setName(roi.getGBType());
                }
                dest.features.add(Feature.fromAnnotation(roi));
            }
            ProjectDocument.fireAllPropertyChanges(dest);
        }
    }

    static EnzymeMix fromEnzymeNames(ProjectDocument doc, String eNames) {
        return ProjectDocument.fromEnzymeNames(doc, eNames.split("\\+"));
    }

    static EnzymeMix fromEnzymeNames(ProjectDocument doc, String ... eNames) {
        if (eNames == null || eNames.length == 0) {
            return null;
        }
        EnzymeMix mix = new EnzymeMix();
        for (String name : eNames) {
            if (!doc.defaultEnzymes.containsKey(name = name.trim())) continue;
            mix.addEnzyme(name);
        }
        return mix.enzymes != null && mix.enzymes.length > 0 ? mix : null;
    }

    static EnzymeMix fromString(ProjectDocument doc, String datafileline) {
        if (!datafileline.startsWith(MIXHEADER)) {
            return null;
        }
        int firstComma = datafileline.indexOf("],[");
        if (firstComma == -1) {
            return null;
        }
        String mixNames = datafileline.substring(MIXHEADER.length(), firstComma);
        return ProjectDocument.fromEnzymeNames(doc, mixNames);
    }

    private static void fireAllPropertyChanges(ProjectDocument doc) {
        doc.fireEvents(new ChangeEvent(7), new ChangeEvent(0, "", doc.name), new ChangeEvent(3, "", doc.accession), new ChangeEvent(2, "", doc.source), new ChangeEvent(1, "", doc.organism), new ChangeEvent(6, !doc.circular, doc.circular), new ChangeEvent(107));
    }

    public void addEnzyme(String enzymeName) {
        if (this.defaultEnzymes != null && this.defaultEnzymes.containsKey(enzymeName)) {
            ProjectEnzyme e = this.defaultEnzymes.get(enzymeName);
            this.selectedEnzymes.add(e);
        }
    }

    public void removeEnzyme(String enzymeName) {
        if (this.defaultEnzymes != null && this.defaultEnzymes.containsKey(enzymeName)) {
            ProjectEnzyme e = this.defaultEnzymes.get(enzymeName);
            this.selectedEnzymes.remove(e.enzyme.name);
        }
    }

    public void addEnzymeMix(String mixName) {
        String[] names;
        EnzymeMix mix = new EnzymeMix();
        for (String name : names = mixName.split("\\+")) {
            if (!this.defaultEnzymes.containsKey(name)) continue;
            mix.addEnzyme(name);
        }
        this.enzymeMixes.add(mix);
    }

    private ProjectEnzyme getEnzyme(String enzyme) {
        return this.defaultEnzymes.get(enzyme);
    }

    void genCuts(EnzymeMix mix) {
        mix.cuts = null;
        ExtensibleArray<Locus> foundCuts = new ExtensibleArray<Locus>(Locus.class);
        for (int x = 0; x < mix.enzymes.length; ++x) {
            ProjectEnzyme enzyme = this.getEnzyme(mix.enzymes[x]);
            if (enzyme.getCutCount() <= 0) continue;
            foundCuts.add((Locus[])enzyme.cuts);
        }
        mix.cuts = foundCuts.toArray();
    }

    void setMapSize(int mapWidth, int mapHeight) {
        this.mapHt = mapHeight;
        this.mapWd = mapWidth;
        double width = mapWidth;
        double height = mapHeight;
        double centerX = width / 2.0;
        double centerY = height / 2.0;
        this.centerLinY = (int)(height * 2.0 / 3.0);
        double maxRadius = Math.min(width, height) / 2.0;
        double lRadius = (4.0 + maxRadius) * 0.99;
        double pRadius = maxRadius * 0.75;
        double jRadius = (lRadius + pRadius) / 2.0;
        this.lCircle = new Circle(centerX, centerY, lRadius);
        this.jCircle = new Circle(centerX, centerY, jRadius);
        this.pCircle = new Circle(centerX, centerY, pRadius);
        this.box_Height = pRadius / 10.0;
        this.pointHeight = pRadius / 10.0;
        if (this.length() > 0) {
            this.needPaths = true;
            this.calcRadians();
        }
    }

    float offsetToLinearOffset(float offset) {
        return (float)this.box_Height * 10.0f * (offset - 1.0f);
    }

    float offsetToCircularOffset(float offset) {
        return (float)((double)offset * this.pCircle.radius);
    }

    void clearFoundCategories() {
        this.foundCategories.clear();
        this.foundCategories.add(this.catNoCategory, this.catNoCategory.name);
    }

    @Override
    public SequenceExportFormat getSEF(int start, int stop) {
        return this.getSEF(start, stop, false);
    }

    public SequenceExportFormat getSEF(int start, int stop, boolean antisense) {
        SequenceExportFormat data = new SequenceExportFormat();
        data.name = this.getName();
        data.circular = this.circular;
        data.qualifiers = this.genSEFQualifiers();
        data.sequence = this.getSequence(start, stop);
        if (!this.features.isEmpty()) {
            Locus selection = new Locus(start, stop);
            ArrayList<ROI> annotations = new ArrayList<ROI>();
            for (ROI f : this.features) {
                ROI newAnnotation;
                if (!selection.intersects(f) || (newAnnotation = Feature.toROI(f)) == null) continue;
                Locus.adjustForSelection(newAnnotation, selection);
                annotations.add(newAnnotation);
            }
            if (!annotations.isEmpty()) {
                data.annotations = new ROI[annotations.size()];
                for (int index = 0; index < annotations.size(); ++index) {
                    data.annotations[index] = (ROI)annotations.get(index);
                }
            }
        }
        if (antisense) {
            data.antisense();
        }
        return data;
    }

    public SequenceExportFormat getSEF(Feature f) {
        SequenceExportFormat data = this.getSEF(f.getStart(), f.getStop(), f.isAntisense());
        data.qualifiers = new Qualifier[]{new Qualifier("name", f.getName()), new Qualifier("plot_ftype", String.valueOf(f.renderer.getLoadIndex())), new Qualifier("color", String.valueOf(ColorTools.colorToInt(f.getColor()))), new Qualifier("source", this.source), new Qualifier("organism", this.organism), new Qualifier("codon_table", this.codonTable.getOrganismName())};
        return data;
    }

    SequenceExportFormat getSEF(PrimerFeature f) {
        ROI roi;
        SequenceExportFormat data = new SequenceExportFormat();
        data.name = f.getName();
        data.sequence = f.foundPrimer.refPrimer.sequence;
        data.annotations = new ROI[1];
        String comment = f.getName() + "\nCategory: " + f.foundPrimer.refPrimer.category.name + "\nStorage Location: " + f.foundPrimer.refPrimer.location + "\nSequence: " + f.foundPrimer.refPrimer.sequence + "\nComment: " + (f.toolTipNote == null ? "" : f.toolTipNote);
        data.annotations[0] = roi = new ROI();
        roi.setColor(primerColor);
        roi.setName(f.getName());
        roi.setGBType("primer_bind");
        roi.qualifiers = new Qualifier[2];
        roi.qualifiers[0] = new Qualifier("note", comment);
        roi.qualifiers[1] = new Qualifier("plot_ftype", String.valueOf(6));
        data.qualifiers = new Qualifier[]{new Qualifier("name", f.getName())};
        return data;
    }

    Undoable runRestorePointUndoable(UndoableAction action) {
        return this.runRestorePointUndoable(action, null, null);
    }

    Undoable runRestorePointUndoable(UndoableAction action, String editTitle) {
        return this.runRestorePointUndoable(action, "Undo " + editTitle, "Redo " + editTitle);
    }

    Undoable runRestorePointUndoable(UndoableAction action, String undoTitle, String redoTitle) {
        UndoableAction undoAction = this.createRestorePointAction();
        if (!action.run()) {
            return null;
        }
        this.fireEvents(restorePointEvents);
        UndoableAction redoAction = this.createRestorePointAction();
        Undoable edit = this.createRestorePointUndoable(undoAction, redoAction);
        if (undoTitle != null) {
            edit.undoName = undoTitle;
        }
        if (redoTitle != null) {
            edit.redoName = redoTitle;
        }
        this.undoManager.addEdit(edit);
        return edit;
    }

    private Undoable createRestorePointUndoable(final UndoableAction undoAction, final UndoableAction redoAction) {
        final boolean isEnabled = this.listenersEnabled;
        Undoable edit = new Undoable(){

            @Override
            public boolean undo() {
                if (undoAction.run()) {
                    ProjectDocument.this.setListenersEnabled(true);
                    ProjectDocument.this.fireEvents(restorePointEvents);
                    ProjectDocument.this.setListenersEnabled(isEnabled);
                    return true;
                }
                return false;
            }

            @Override
            public boolean redo() {
                if (redoAction.run()) {
                    ProjectDocument.this.setListenersEnabled(true);
                    ProjectDocument.this.fireEvents(restorePointEvents);
                    ProjectDocument.this.setListenersEnabled(isEnabled);
                    return true;
                }
                return false;
            }
        };
        return edit;
    }

    UndoableAction createRestorePointAction() {
        final String sequence = this.getSequence();
        final ExtensibleArray<ROI> oldFeatures = new ExtensibleArray<ROI>(ROI.class);
        for (ROI f : this.features) {
            oldFeatures.add((Feature)f.clone());
        }
        final ArrayList<EnzymeFeature> oldEList = new ArrayList<EnzymeFeature>();
        final ArrayList<PrimerFeature> oldPList = new ArrayList<PrimerFeature>();
        for (EnzymeFeature fe : this.foundEnzymes) {
            oldEList.add(fe.clone());
        }
        for (PrimerFeature pe : this.foundPrimers) {
            oldPList.add(pe.clone());
        }
        final boolean wasChanged = this.isChanged();
        final boolean isEnabled = this.listenersEnabled;
        UndoableAction action = new UndoableAction(){

            @Override
            public boolean run() {
                ProjectDocument.this.setListenersEnabled(false);
                ProjectDocument.this.setSequence(sequence);
                ProjectDocument.this.selectedItems.clear();
                ProjectDocument.this.mouseoverItem = null;
                ProjectDocument.this.features.copyFrom(oldFeatures);
                ProjectDocument.this.foundEnzymes.clear();
                for (EnzymeFeature fe : oldEList) {
                    ProjectDocument.this.foundEnzymes.add(fe);
                }
                ProjectDocument.this.foundPrimers.clear();
                for (PrimerFeature pe : oldPList) {
                    ProjectDocument.this.foundPrimers.add(pe.clone());
                }
                ProjectDocument.this.changed = wasChanged;
                ProjectDocument.this.setListenersEnabled(isEnabled);
                return true;
            }
        };
        return action;
    }

    UndoableAction createFeatureRestorePoint(final Feature feature) {
        final Feature oldFeature = feature.clone();
        final boolean wasChanged = this.isChanged();
        final boolean isEnabled = this.listenersEnabled;
        UndoableAction action = new UndoableAction(){

            @Override
            public boolean run() {
                feature.cloneFrom(oldFeature);
                ProjectDocument.this.changed = wasChanged;
                ProjectDocument.this.setListenersEnabled(true);
                ProjectDocument.this.fireEvents(new ChangeEvent(108), new ChangeEvent(106), new ChangeEvent(10));
                ProjectDocument.this.setListenersEnabled(isEnabled);
                return true;
            }
        };
        return action;
    }

    Base[] getBaseArray() {
        return this.getSequenceBaseArray();
    }

    void regenerateAA() {
        this.regenAA();
    }

    void generateDigestBands(EnzymeMix mix) {
        int seqLen = this.sequence.size();
        if (mix.cuts == null || mix.cuts.length == 0 || mix.cuts.length < 2 && this.circular) {
            mix.bands = ProjectDocument.genArray(1);
            mix.bands[0].setStart(1);
            mix.bands[0].setStop(seqLen);
            return;
        }
        ProjectDocument.sort(mix.cuts, Locus.firstToLast);
        int bandCount = this.circular ? mix.cuts.length : mix.cuts.length + 1;
        mix.bands = ProjectDocument.genArray(bandCount);
        if (this.circular) {
            for (int x = 0; x < bandCount - 1; ++x) {
                mix.bands[x].setStart(mix.cuts[x].getStart());
                mix.bands[x].setStop(mix.cuts[x + 1].getStart() - 1);
            }
            mix.bands[bandCount - 1].setStart(mix.cuts[bandCount - 1].getStart() - 1);
            mix.bands[bandCount - 1].setStop(mix.cuts[0].getStart() - 1);
        } else {
            mix.bands[0].setStart(1);
            mix.bands[0].setStop(mix.cuts[0].getStart());
            for (int x = 1; x < bandCount - 1; ++x) {
                mix.bands[x].setStart(mix.cuts[x - 1].getStart() + 1);
                mix.bands[x].setStop(mix.cuts[x].getStart());
            }
            mix.bands[bandCount - 1].setStart(mix.bands[bandCount - 2].getStop() + 1);
            mix.bands[bandCount - 1].setStop(seqLen);
        }
    }

    void generateDigestBands(ProjectEnzyme e) {
        int seqLen = this.sequence.size();
        if (e.cuts == null || e.cuts.length < 2 && this.circular) {
            e.bands = ProjectDocument.genArray(1);
            e.bands[0].setStart(1);
            e.bands[0].setStop(seqLen);
            return;
        }
        ProjectDocument.sort(e.cuts, Locus.firstToLast);
        int bandCount = this.circular ? e.cuts.length : e.cuts.length + 1;
        e.bands = ProjectDocument.genArray(bandCount);
        if (this.circular) {
            for (int x = 0; x < bandCount - 1; ++x) {
                e.bands[x].setStart(e.cuts[x].getStart());
                e.bands[x].setStop(e.cuts[x + 1].getStart() - 1);
            }
            e.bands[bandCount - 1].setStart(e.cuts[bandCount - 1].getStart() - 1);
            e.bands[bandCount - 1].setStop(e.cuts[0].getStart() - 1);
        } else {
            e.bands[0].setStart(1);
            e.bands[0].setStop(e.cuts[0].getStart());
            for (int x = 1; x < bandCount - 1; ++x) {
                e.bands[x].setStart(e.cuts[x - 1].getStart() + 1);
                e.bands[x].setStop(e.cuts[x].getStart());
            }
            e.bands[bandCount - 1].setStart(e.bands[bandCount - 2].getStop() + 1);
            e.bands[bandCount - 1].setStop(seqLen);
        }
    }

    private static Locus[] genArray(int count) {
        Locus[] outArray = new Locus[count];
        for (int x = 0; x < count; ++x) {
            outArray[x] = new Locus();
        }
        return outArray;
    }

    private static void sort(Locus[] sites, Comparator c) {
        if (sites.length > 1) {
            for (int x = 0; x < sites.length - 1; ++x) {
                int highIndex = x;
                for (int y = x + 1; y < sites.length; ++y) {
                    if (c.compare(sites[highIndex], sites[y]) <= 0) continue;
                    highIndex = y;
                }
                if (highIndex == x) continue;
                Locus f1 = sites[x];
                sites[x] = sites[highIndex];
                sites[highIndex] = f1;
            }
        }
    }

    void updateREs() {
        this.foundEnzymes.clear();
        this.linkedEnzymes.clear();
        if (!this.selectedEnzymes.isEmpty()) {
            for (ProjectEnzyme e : this.selectedEnzymes) {
                this.addFoundEnzyme(e);
            }
        }
        if (!this.enzymeFilters.isEmpty()) {
            for (ProjectEnzyme e : this.defaultEnzymes) {
                if (this.selectedEnzymes.containsKey(e.enzyme.name)) continue;
                boolean add = true;
                for (EnzymeFilter ef : this.enzymeFilters) {
                    if (this.filterEnzyme(ef, e)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.addFoundEnzyme(e);
            }
        }
    }

    boolean filterEnzyme(EnzymeFilter ef, ProjectEnzyme e) {
        if (e.getCutCount() == 0) {
            return false;
        }
        int sCounts = 0;
        for (Locus cut : e.cuts) {
            if (cut.getStart() < ef.minBp || cut.getStart() > ef.maxBp) continue;
            ++sCounts;
        }
        return sCounts >= ef.minCuts && sCounts <= ef.maxCuts;
    }

    public boolean contains(ROI roi) {
        return this.features.contains(roi);
    }

    public boolean isSelected(ROI roi) {
        return this.selectedItems.contains(roi);
    }

    public ROI[] getROIs() {
        return (ROI[])this.features.toArray();
    }
}

