/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import Sequences.DNA;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DNACalculator {
    private static final double AVERAGE_MOLAR_MASS_BP = 650.0;
    private static final double AVOGADROS_NUMBER = 6.02214076E23;
    final String[] units = new String[]{"", "m", "\u03bc", "n", "p", "f", "a", "z", "y"};
    final double[] factors = new double[]{1.0, 1000.0, 1000000.0, 1.0E9, 1.0E12, 1.0E15, 1.0E18, 1.0E121, 1.0E24};

    public String massToMoles(double dnaGrams, String sequence) {
        DNA seq = new DNA(sequence);
        if (seq.length() > 0) {
            int atCount = seq.getATCount();
            int gcCount = seq.getGCCount();
            double mMass = 617.44 * (double)atCount + 618.43 * (double)gcCount;
            return this.massToMoles(dnaGrams, seq.length(), mMass);
        }
        return "Input sequence may not be empty.";
    }

    public String massToMoles(double dnaGrams, int basePairs) {
        return this.massToMoles(dnaGrams, basePairs, (double)basePairs * 650.0);
    }

    public String massToMoles(double dnaMass, String units, int basePairs, double dnaMolarMass) {
        return this.massToMoles(this.convertToGrams(dnaMass, units), basePairs, dnaMolarMass);
    }

    public String massToMoles(double dnaGrams, int basePairs, double dnaMolarMass) {
        if (dnaGrams <= 0.0 || basePairs <= 0) {
            return "Input values must be greater than zero.";
        }
        if (dnaGrams <= 0.0 || basePairs <= 0) {
            return "Input values must be greater than zero.";
        }
        if (dnaMolarMass <= 0.0) {
            dnaMolarMass = (double)basePairs * 650.0;
        }
        double moles = dnaGrams / dnaMolarMass;
        double copies = moles * 6.02214076E23;
        String outVal = "Input DNA: " + dnaGrams + " grams\nDNA length: " + basePairs + " base pairs\nMolar mass of DNA molecule: " + this.round(dnaMolarMass, 2) + " g/mol\nNumber of moles: " + this.formatValue(moles) + "mol\nMoles of DNA 3\u2019/5\u2019 ends: " + this.formatValue(moles * 2.0) + "mol\nNumber of copies (molecules): " + this.formatSci(copies, 4);
        return outVal;
    }

    public String molesToMass(double value, String moleUnit, String sequence) {
        DNA seq = new DNA(sequence);
        return this.molesToMass(value, moleUnit, seq.length(), this.getMolarMass(sequence));
    }

    public double getMolarMass(String dna) {
        DNA seq = new DNA(dna);
        return this.getMolarMass(seq);
    }

    public double getMolarMass(DNA seq) {
        if (seq.length() > 0) {
            int atCount = seq.getATCount();
            int gcCount = seq.getGCCount();
            return 617.44 * (double)atCount + 618.43 * (double)gcCount;
        }
        return 0.0;
    }

    public double getMolarMass(int basePairs) {
        return (double)basePairs * 650.0;
    }

    public String molesToMass(double value, String moleUnit, int basePairs) {
        return this.molesToMass(value, moleUnit, basePairs, 0.0);
    }

    public String molesToMass(double value, String moleUnit, int basePairs, double dnaMolarMass) {
        if (value <= 0.0 || basePairs <= 0) {
            return "Input values must be greater than zero.";
        }
        if (dnaMolarMass <= 0.0) {
            dnaMolarMass = (double)basePairs * 650.0;
        }
        double moles = this.convertToMoles(value, moleUnit);
        double grams = moles * dnaMolarMass;
        String formattedMass = this.formatValue(grams) + "g";
        String outVal = String.format("Input DNA: %.2f %s", value, moleUnit) + "\nDNA length: " + basePairs + " base pairs\nMolar mass of DNA molecule: " + this.round(dnaMolarMass, 2) + " g/mol\nMass DNA: " + formattedMass;
        return outVal;
    }

    private double convertToMoles(double value, String moleUnit) {
        switch (moleUnit.toLowerCase()) {
            case "mol": {
                return value;
            }
            case "mmol": 
            case "millimole": 
            case "millimoles": {
                return value * 0.001;
            }
            case "umol": 
            case "\u03bcmol": 
            case "\u00b5mol": 
            case "micromole": 
            case "micromoles": {
                return value * 1.0E-6;
            }
            case "nmol": 
            case "nanomole": 
            case "nanomoles": {
                return value * 1.0E-9;
            }
            case "pmol": 
            case "picomole": 
            case "picomoles": {
                return value * 1.0E-12;
            }
            case "fmol": 
            case "femtomole": 
            case "femtomoles": {
                return value * 1.0E-15;
            }
            case "amol": 
            case "attomole": 
            case "attomoles": {
                return value * 1.0E-18;
            }
            case "zmol": 
            case "zettomole": 
            case "zettomoles": {
                return value * 1.0E-21;
            }
            case "ymol": 
            case "yoctomole": 
            case "yoctomoles": {
                return value * 1.0E-24;
            }
        }
        throw new IllegalArgumentException("Unknown mole unit: " + moleUnit);
    }

    private double convertToGrams(double value, String unit) {
        switch (unit.toLowerCase()) {
            case "g": 
            case "gram": 
            case "grams": {
                return value;
            }
            case "mg": 
            case "milligram": 
            case "milligrams": {
                return value * 0.001;
            }
            case "ug": 
            case "\u03bcg": 
            case "\u00b5g": 
            case "microgram": 
            case "micrograms": {
                return value * 1.0E-6;
            }
            case "ng": 
            case "nanogram": 
            case "nanograms": {
                return value * 1.0E-9;
            }
            case "pg": 
            case "picogram": 
            case "picograms": {
                return value * 1.0E-12;
            }
            case "fg": 
            case "femtogram": 
            case "femtograms": {
                return value * 1.0E-15;
            }
            case "ag": 
            case "attogram": 
            case "attograms": {
                return value * 1.0E-18;
            }
            case "zg": 
            case "zettogram": 
            case "zettograms": {
                return value * 1.0E-21;
            }
            case "yg": 
            case "yoctogram": 
            case "yoctograms": {
                return value * 1.0E-24;
            }
        }
        throw new IllegalArgumentException("Unknown gram unit: " + unit);
    }

    private String formatValue(double value) {
        int unitIndex;
        double absGrams = Math.abs(value);
        for (unitIndex = 0; unitIndex < this.factors.length - 1 && absGrams * this.factors[unitIndex + 1] < 1000.0; ++unitIndex) {
        }
        double valueInUnit = value * this.factors[unitIndex];
        return String.format("%.2f %s", valueInUnit, this.units[unitIndex]);
    }

    private double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    private String formatSci(double value, int places) {
        return String.format("%." + places + "e", value);
    }

    private String formatMoles(double moles) {
        return this.formatValue(moles) + "mol";
    }

    public static void main(String[] args) {
        DNACalculator calculator = new DNACalculator();
        System.out.println(calculator.massToMoles(0.01, "atggtgagcaagggcgaggaggataacatggccatcatcaaggagttcatgcgcttcaaggtgcacatggagggctccgtgaacggccacgagttcgagatcgagggcgagggcgagggccgcccctacgagggcacccagaccgccaagctgaaggtgaccaagggtggccccctgcccttcgcctgggacatcctgtcccctcagttcatgtacggctccaaggcctacgtgaagcaccccgccgacatccccgactacttgaagctgtccttccccgagggcttcaagtgggagcgcgtgatgaacttcgaggacggcggcgtggtgaccgtgacccaggactcctccctgcaggacggcgagttcatctacaaggtgaagctgcgcggcaccaacttcccctccgacggccccgtaatgcagaagaagaccatgggctgggaggcctcctccgagcggatgtaccccgaggacggcgccctgaagggcgagatcaagcagaggctgaagctgaaggacggcggccactacgacgctgaggtcaagaccacctacaaggccaagaagcccgtgcagctgcccggcgcctacaacgtcaacatcaagttggacatcacctcccacaacgaggactacaccatcgtggaacagtacgaacgcgccgagggccgccactccaccggcggcatggacgagctgtacaagtag"));
        System.out.println(calculator.molesToMass(2.5, "nmol", 5000));
        System.out.println(calculator.molesToMass(0.1, "\u03bcmol", 10000));
        System.out.println(calculator.molesToMass(1.0, "pmol", 2000));
    }
}

