/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import BioDocumentFilters.BioAllowedKeyFilter;
import DocumentFilters.DocumentAllowedKeyFilter;
import Sequences.DNA;
import Tools.DNACalculator;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;

public class MCalc2
extends JFrame {
    DNACalculator calculator = new DNACalculator();
    private JComboBox<String> cmbBp;
    private JComboBox<String> cmbUnits;
    private JComboBox<String> cmbUnits2;
    private JButton cmdClose;
    private JButton cmdConvert;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane tabbedPaneMoleMass;
    private JTabbedPane tabbedPaneSeqLen;
    private JTextField txtLen;
    private JTextField txtMass;
    private JTextField txtMoles;
    private JTextArea txtResults;
    private JTextArea txtSeq;

    public void setSequence(String seq) {
        this.txtSeq.setText(seq);
    }

    public MCalc2() {
        this.initComponents();
        ((AbstractDocument)this.txtMass.getDocument()).setDocumentFilter((DocumentFilter)DocumentAllowedKeyFilter.NumberFilter);
        ((AbstractDocument)this.txtMoles.getDocument()).setDocumentFilter((DocumentFilter)DocumentAllowedKeyFilter.NumberFilter);
        ((AbstractDocument)this.txtSeq.getDocument()).setDocumentFilter((DocumentFilter)BioAllowedKeyFilter.DNA_ACGT_Filter);
        this.txtSeq.select(0, 0);
        this.setLocationRelativeTo(null);
    }

    private void calculate() {
        String output;
        int bp;
        double dnaMolarMass;
        if (this.tabbedPaneSeqLen.getSelectedIndex() == 0) {
            DNA seq = new DNA(this.txtSeq.getText());
            dnaMolarMass = this.calculator.getMolarMass(seq);
            bp = seq.length();
        } else {
            bp = Integer.parseInt(this.txtLen.getText());
            dnaMolarMass = this.calculator.getMolarMass(bp);
        }
        if (this.tabbedPaneMoleMass.getSelectedIndex() == 0) {
            double grams = Double.parseDouble(this.txtMass.getText());
            output = this.calculator.massToMoles(grams, (String)this.cmbUnits.getSelectedItem(), bp, dnaMolarMass);
        } else {
            double moles = Double.parseDouble(this.txtMoles.getText());
            output = this.calculator.molesToMass(moles, (String)this.cmbUnits2.getSelectedItem(), bp, dnaMolarMass);
        }
        this.txtResults.setText(output);
        this.txtResults.select(0, 0);
    }

    private void initComponents() {
        this.tabbedPaneMoleMass = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.cmbUnits = new JComboBox();
        this.txtMass = new JTextField();
        this.jPanel2 = new JPanel();
        this.cmbUnits2 = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.txtMoles = new JTextField();
        this.cmdConvert = new JButton();
        this.tabbedPaneSeqLen = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtSeq = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.cmbBp = new JComboBox();
        this.txtLen = new JTextField();
        this.cmdClose = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.txtResults = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Moles and Mass Conversion");
        this.jLabel3.setText("DNA Mass");
        this.jLabel5.setText("Units");
        this.cmbUnits.setModel(new DefaultComboBoxModel<String>(new String[]{"g", "mg", "\u00b5g", "ng", "pg", "fg"}));
        this.txtMass.setHorizontalAlignment(0);
        this.txtMass.setText("1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtMass, -2, 64, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.cmbUnits, -2, 72, -2)).addContainerGap(76, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMass, -2, -1, -2).addComponent(this.cmbUnits, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.tabbedPaneMoleMass.addTab("Mass to Moles", this.jPanel1);
        this.cmbUnits2.setModel(new DefaultComboBoxModel<String>(new String[]{"mol", "mmol", "\u00b5mol", "nmol", "pmol"}));
        this.jLabel6.setText("DNA moles");
        this.jLabel7.setText("Units");
        this.txtMoles.setHorizontalAlignment(0);
        this.txtMoles.setText("1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtMoles, -2, 64, -2).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.cmbUnits2, -2, 72, -2)).addContainerGap(76, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMoles, -2, -1, -2).addComponent(this.cmbUnits2, -2, -1, -2)).addContainerGap(23, Short.MAX_VALUE)));
        this.tabbedPaneMoleMass.addTab("Moles to Mass", this.jPanel2);
        this.cmdConvert.setText("Convert");
        this.cmdConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MCalc2.this.cmdConvertActionPerformed(evt);
            }
        });
        this.jLabel1.setText("DNA Sequence");
        this.txtSeq.setColumns(20);
        this.txtSeq.setLineWrap(true);
        this.txtSeq.setRows(5);
        this.txtSeq.setText("atggtgagcaagggcgaggaggataacatggccatcatcaaggagttcatgcgcttcaaggtgcacatggagggctccgtgaacggccacgagttcgagatcgagggcgagggcgagggccgcccctacgagggcacccagaccgccaagctgaaggtgaccaagggtggccccctgcccttcgcctgggacatcctgtcccctcagttcatgtacggctccaaggcctacgtgaagcaccccgccgacatccccgactacttgaagctgtccttccccgagggcttcaagtgggagcgcgtgatgaacttcgaggacggcggcgtggtgaccgtgacccaggactcctccctgcaggacggcgagttcatctacaaggtgaagctgcgcggcaccaacttcccctccgacggccccgtaatgcagaagaagaccatgggctgggaggcctcctccgagcggatgtaccccgaggacggcgccctgaagggcgagatcaagcagaggctgaagctgaaggacggcggccactacgacgctgaggtcaagaccacctacaaggccaagaagcccgtgcagctgcccggcgcctacaacgtcaacatcaagttggacatcacctcccacaacgaggactacaccatcgtggaacagtacgaacgcgccgagggccgccactccaccggcggcatggacgagctgtacaagtag");
        this.jScrollPane1.setViewportView(this.txtSeq);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addComponent(this.jScrollPane1, -2, 333, -2)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 95, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPaneSeqLen.addTab("By Sequence", this.jPanel3);
        this.jLabel2.setText("DNA Length");
        this.jLabel4.setText("Units");
        this.cmbBp.setModel(new DefaultComboBoxModel<String>(new String[]{"bp", "kbp"}));
        this.txtLen.setHorizontalAlignment(0);
        this.txtLen.setText("1");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtLen, -2, 64, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.cmbBp, -2, 72, -2)).addContainerGap(184, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLen, -2, -1, -2).addComponent(this.cmbBp, -2, -1, -2)).addContainerGap(79, Short.MAX_VALUE)));
        this.tabbedPaneSeqLen.addTab("By Length", this.jPanel4);
        this.cmdClose.setText("Close");
        this.cmdClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MCalc2.this.cmdCloseActionPerformed(evt);
            }
        });
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder("Results"));
        this.txtResults.setColumns(20);
        this.txtResults.setRows(5);
        this.txtResults.setBorder(null);
        this.jScrollPane2.setViewportView(this.txtResults);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPaneSeqLen, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.tabbedPaneMoleMass, -2, 236, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmdConvert, -2, 99, -2).addComponent(this.cmdClose, -2, 99, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 249, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tabbedPaneSeqLen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPaneMoleMass, -2, 108, -2).addGroup(layout.createSequentialGroup().addComponent(this.cmdConvert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmdClose)))).addComponent(this.jScrollPane2)).addContainerGap()));
        this.pack();
    }

    private void cmdCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cmdConvertActionPerformed(ActionEvent evt) {
        this.calculate();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MCalc2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MCalc2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MCalc2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MCalc2.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MCalc2 dialog = new MCalc2();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

