/*
 * Decompiled with CFR 0.152.
 */
package SeqTools;

import DNATools.MutationAnnotation;
import ProteinTools.CodonTable;
import Sequences.DNA;
import java.util.ArrayList;

class SeqMutator {
    public static final int CODON_CLOSEST_SEQUENCE = 0;
    public static final int CODON_HIGHEST_FREQUENCY = 1;
    private int codonChoice = 1;
    CodonTable codonTable = new CodonTable();
    private String error = "";
    private final DNA sequence = new DNA();
    private final ArrayList<MutationAnnotation> mutations = new ArrayList();
    private String comment = "";

    public void setCodonChoice(int choice) {
        if (choice == 0 || choice == 1) {
            this.codonChoice = choice;
        }
    }

    public String getError() {
        return this.error;
    }

    public String getSequence() {
        return this.sequence.getSequence();
    }

    public void setSequence(String Seq) {
        this.sequence.setSequence(Seq.toUpperCase());
    }

    public SeqMutator(String seq) {
        this.setSequence(seq);
    }

    private boolean addcDNAMutation(MutationAnnotation mutation) {
        if (this.isDNAMutationValid(mutation)) {
            this.error = "";
            this.mutations.add(mutation);
            return true;
        }
        return false;
    }

    public boolean isDNAMutationValid(MutationAnnotation mutation) {
        if (mutation.get_DNAStart() < 1 || mutation.get_DNAStart() > this.sequence.length()) {
            this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\tInvalid base specified";
            this.logError(this.error);
            return false;
        }
        if (!this.mutations.isEmpty()) {
            for (int x = 0; x < this.mutations.size(); ++x) {
                if (this.mutations.get(x).get_DNAStart() != mutation.get_DNAStart()) continue;
                this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\tposition already mutated";
                this.logError(this.error);
                return false;
            }
        }
        if (!this.sequence.getSequence(mutation.get_DNAStart(), mutation.get_DNAStart() + mutation.getOriginalResidue().length() - 1).equals(mutation.getOriginalResidue())) {
            this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\tbp" + mutation.get_DNAStart() + " = " + this.sequence.getSequence(mutation.get_DNAStart(), mutation.get_DNAStart() + mutation.getOriginalResidue().length() - 1);
            this.logError(this.error);
            return false;
        }
        return true;
    }

    void logError(String err) {
        System.err.println(err);
    }

    private boolean addAAMutation(MutationAnnotation mutation) {
        String curCodonAA;
        String codonSeq = this.sequence.getSequence(mutation.get_DNAStart(), mutation.get_DNAStart() + 2);
        if (codonSeq == null) {
            return false;
        }
        switch (mutation.getOriginalResidue().length()) {
            case 1: {
                curCodonAA = this.codonTable.translateCodon(codonSeq, CodonTable.LetterCode.e1_Letter_Code);
                break;
            }
            case 3: {
                curCodonAA = this.codonTable.translateCodon(codonSeq, CodonTable.LetterCode.e3_Letter_Code);
                break;
            }
            default: {
                this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\toriginal aa = " + mutation.getOriginalResidue();
                this.logError(this.error);
                return false;
            }
        }
        String cAAUC = curCodonAA.toUpperCase();
        boolean same1 = cAAUC.equals(mutation.getOriginalResidue().toUpperCase());
        if (!same1) {
            this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\toriginal codon (" + codonSeq + ", " + curCodonAA + ") did not match\n\tthe expected amino acid (" + mutation.getOriginalResidue() + ")";
            this.logError(this.error);
            return false;
        }
        boolean same2 = cAAUC.equals(mutation.getNewResidue().toUpperCase());
        if (same2) {
            this.error = "Target and mutated amino acids are the same)";
            this.logError(this.error);
            return false;
        }
        boolean deletion = SeqMutator.isDeletion(mutation.getNewResidue());
        if (deletion) {
            int bpPos = mutation.get_DNAStart();
            this.addDeletionRangeToDest(bpPos, bpPos + 2);
        } else {
            String newCodon = this.codonChoice == 0 ? this.codonTable.getNearestCodon(mutation.getNewResidue(), codonSeq) : this.codonTable.getHighestCodon(mutation.getNewResidue());
            int BpPos = mutation.get_DNAStart();
            for (int x = 0; x < 3; ++x) {
                String newBp;
                String oldBp = codonSeq.substring(x, x + 1);
                if (oldBp.equals(newBp = newCodon.substring(x, x + 1))) continue;
                String tmpDNAString = "c." + oldBp + String.valueOf(BpPos + x) + newBp;
                if (!this.addcDNAMutation(new MutationAnnotation(tmpDNAString))) {
                    return false;
                }
                this.comment = this.comment.length() > 0 ? this.comment + "+" + tmpDNAString : tmpDNAString;
            }
            if (this.comment.length() > 0) {
                this.comment = this.comment + " (" + codonSeq + ">" + newCodon + ")";
                String refName = mutation.sequenceName;
                if (refName != null && refName.length() > 0 && !refName.equalsIgnoreCase("reference")) {
                    this.comment = this.comment + " in " + refName;
                }
            }
        }
        return true;
    }

    public boolean isAAMutationValid(MutationAnnotation mutation) {
        String curCodonAA;
        String codonSeq = this.sequence.getSequence(mutation.get_DNAStart(), mutation.get_DNAStart() + 2);
        if (codonSeq == null) {
            return false;
        }
        switch (mutation.getOriginalResidue().length()) {
            case 1: {
                curCodonAA = this.codonTable.translateCodon(codonSeq, CodonTable.LetterCode.e1_Letter_Code);
                break;
            }
            case 3: {
                curCodonAA = this.codonTable.translateCodon(codonSeq, CodonTable.LetterCode.e3_Letter_Code);
                break;
            }
            default: {
                this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\tInvalid amino acid specified as the\n\toriginal residue(" + mutation.getOriginalResidue() + ")";
                this.logError(this.error);
                return false;
            }
        }
        String cAAUC = curCodonAA.toUpperCase();
        boolean same1 = cAAUC.equals(mutation.getOriginalResidue().toUpperCase());
        if (!same1) {
            this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\tFound codon (" + codonSeq + ", " + curCodonAA + ") did not match the\nexpected amino acid (" + mutation.getOriginalResidue() + ")";
            this.logError(this.error);
            return false;
        }
        boolean same2 = cAAUC.equals(mutation.getNewResidue().toUpperCase());
        if (same2) {
            this.error = "Mutation invalid: " + mutation.getAnnotation() + "\n\tTarget and mutated amino acids are the same.";
            this.logError(this.error);
            return false;
        }
        return true;
    }

    private static boolean isDeletion(String newCodon) {
        return newCodon == null || newCodon.length() == 0 || newCodon.toUpperCase().equals("DEL");
    }

    public boolean addMutation(MutationAnnotation mutation) {
        if (!mutation.isValid()) {
            this.error = mutation.getError();
            return false;
        }
        switch (mutation.getAnnotationType()) {
            case 99: {
                this.error = "mutation type unknown";
                this.logError(this.error);
                return false;
            }
            case 1: {
                return this.addAAMutation(mutation);
            }
            case 0: {
                return this.addcDNAMutation(mutation);
            }
        }
        return true;
    }

    public boolean isMutationValid(MutationAnnotation mutation) {
        if (!mutation.isValid()) {
            this.error = mutation.getError();
            this.logError("Mutation invalid: " + this.error);
            return false;
        }
        switch (mutation.getAnnotationType()) {
            case 99: {
                this.error = "Mutation invalid: Mutation type unknown";
                this.logError(this.error);
                return false;
            }
            case 1: {
                return this.isAAMutationValid(mutation);
            }
            case 0: {
                return this.isDNAMutationValid(mutation);
            }
        }
        return true;
    }

    public boolean deleteRegion(int bpStart, int bpStop) {
        return false;
    }

    public boolean addMutation(String mutation) {
        MutationAnnotation results = new MutationAnnotation();
        String uMutation = mutation.toUpperCase();
        if (results.setMutation(uMutation)) {
            return this.addMutation(results);
        }
        this.error = results.getError();
        this.logError(this.error);
        return false;
    }

    public boolean addMutation(int bpPos, String origBase, String newBase) {
        return this.addMutation(new MutationAnnotation(bpPos, origBase, newBase));
    }

    public boolean addDeletionRange(int bpDelPosStart, int bpDelPosStop) {
        return this.addDeletionRangeToDest(bpDelPosStart, bpDelPosStop);
    }

    private boolean addDeletionRangeToDest(int bpDelPosStart, int bpDelPosStop) {
        if (bpDelPosStart <= bpDelPosStop && bpDelPosStop <= this.sequence.length()) {
            for (int x = bpDelPosStart; x <= bpDelPosStop; ++x) {
                this.addMutation(new MutationAnnotation(x, this.sequence.getSequence(x, x), ""));
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.mutations.clear();
        this.error = "";
        this.comment = "";
    }

    public String mutateSequence() {
        if (this.mutations.isEmpty()) {
            this.error = "No Mutations Found.";
            this.logError(this.error);
            return null;
        }
        DNA tmpDNA = new DNA();
        tmpDNA.setSequence(this.sequence.getSequence().toLowerCase());
        int firstPos = this.sequence.length() + 1;
        int lastPos = 0;
        for (int x = 0; x < this.mutations.size(); ++x) {
            int cBase = this.mutations.get(x).get_DNAStart();
            if (cBase < firstPos) {
                firstPos = cBase;
            }
            if (cBase > lastPos) {
                lastPos = cBase;
            }
            String newBase = this.mutations.get(x).getNewResidue().toUpperCase();
            tmpDNA.replace(cBase, cBase, newBase);
        }
        return tmpDNA.getSequence();
    }
}

