/*
 * Decompiled with CFR 0.152.
 */
package SeqTools;

import SeqTools.FrmMutator;
import Sequences.DNA;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import plot.Feature;
import plot.PLOTJ;
import plot.PLOTJPlugin;
import plot.ProjectDocument;

public class SequenceMutator
extends PLOTJPlugin {
    String iconPath = "/icons/mutate.png";
    static ImageIcon plus = new ImageIcon(FrmMutator.class.getResource("/icons/Plus.png"));
    static ImageIcon first = new ImageIcon(FrmMutator.class.getResource("/icons/First.png"));
    static ImageIcon last = new ImageIcon(FrmMutator.class.getResource("/icons/Last.png"));
    static ImageIcon up = new ImageIcon(FrmMutator.class.getResource("/icons/Up.png"));
    static ImageIcon down = new ImageIcon(FrmMutator.class.getResource("/icons/Down.png"));
    static ImageIcon xred = new ImageIcon(FrmMutator.class.getResource("/icons/XRED1.png"));
    static ImageIcon question = new ImageIcon(FrmMutator.class.getResource("/icons/Question.png"));
    static ImageIcon largeIcon = new ImageIcon(FrmMutator.class.getResource("/icons/mutate256.png"));

    public SequenceMutator() {
        this.setName("Feature Mutator");
        this.setDescription("Mutates a selected feature");
        this.setIcon(this.iconPath);
    }

    public void run() {
        ProjectDocument doc = PLOTJ.getActiveDocument();
        FrmMutator f = new FrmMutator(null, true);
        f.setIconImage(largeIcon.getImage());
        String oSeq = null;
        String title = null;
        if (doc != null && doc.length() > 0) {
            Feature feat = doc.getSelectedItem();
            if (feat == null) {
                oSeq = doc.getSequence();
                title = "Sequence Mutator: " + doc.getName();
            } else {
                oSeq = doc.getSequence(feat.getStart(), feat.getStop(), feat.isAntisense());
                title = "Sequence Mutator: " + feat.getName();
            }
            f.doc = doc;
            f.cmdApply.setEnabled(true);
        } else {
            String seq = (String)JOptionPane.showInputDialog((Component)PLOTJ.getActiveInstance(), "Enter sequence to mutate", "Manual Sequence Entry", 3, null, null, "atggtgagcaagggcgaggaggataacatggccatcatcaaggagttcatgcgcttcaaggtgcacatggagggctccgtgaacggccacgagttcgagatcgagggcgagggcgagggccgcccctacgagggcacccagaccgccaagctgaaggtgaccaagggtggccccctgcccttcgcctgggacatcctgtcccctcagttcatgtacggctccaaggcctacgtgaagcaccccgccgacatccccgactacttgaagctgtccttccccgagggcttcaagtgggagcgcgtgatgaacttcgaggacggcggcgtggtgaccgtgacccaggactcctccctgcaggacggcgagttcatctacaaggtgaagctgcgcggcaccaacttcccctccgacggccccgtaatgcagaagaagaccatgggctgggaggcctcctccgagcggatgtaccccgaggacggcgccctgaagggcgagatcaagcagaggctgaagctgaaggacggcggccactacgacgctgaggtcaagaccacctacaaggccaagaagcccgtgcagctgcccggcgcctacaacgtcaacatcaagttggacatcacctcccacaacgaggactacaccatcgtggaacagtacgaacgcgccgagggccgccactccaccggcggcatggacgagctgtacaagtag");
            if (seq == null) {
                return;
            }
            if ((seq = DNA.filterSequence((String)seq)).length() > 0) {
                oSeq = seq;
                title = "Sequence Mutator: Manual Sequence Entry";
            }
        }
        if (oSeq != null) {
            f.setSequence(oSeq);
            f.setTitle(title);
            f.setLocationRelativeTo((Component)PLOTJ.getActiveInstance());
            f.setVisible(true);
        } else {
            JOptionPane.showMessageDialog((Component)PLOTJ.getActiveInstance(), "This plugin cannot run on an empty document and zero-length sequence", "Error", 0);
        }
    }
}

