/*
 * Decompiled with CFR 0.152.
 */
package Tools;

import Tools.FrmOutput;
import java.util.ArrayList;

public class HTMLTableMaker {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private static final String header = "<html>\n<head>\n<style>\nth {\n    white-space: nowrap;\n}</style>\n</head>\n<body>";
    private static final String tableHeader = "<table><tr>";
    private static final String rowHeader = "<tr>";
    private static final String rowfooter = "</tr>";
    private static final String footer = "</table></body></html>";
    ArrayList<Column> columns = new ArrayList();
    ArrayList<Cell[]> rows = new ArrayList();

    public void clear() {
        this.columns.clear();
        this.rows.clear();
    }

    public void clearRows() {
        this.rows.clear();
    }

    public void setColumns(String ... texts) {
        this.clear();
        for (String t : texts) {
            Column col = new Column(t, 1, true);
            col.setBold(true);
            col.setUnderlined(true);
            this.columns.add(col);
        }
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public String getTable() {
        StringBuilder tableHTML = new StringBuilder("<html>\n<head>\n<style>\nth {\n    white-space: nowrap;\n}</style>\n</head>\n<body><table><tr>");
        for (Column c : this.columns) {
            tableHTML.append(c.getHTML());
        }
        tableHTML.append(rowfooter);
        int colCount = this.columns.size();
        for (Cell[] cols : this.rows) {
            tableHTML.append(rowHeader);
            int min = cols == null || cols.length == 0 ? 0 : Math.min(colCount, cols.length);
            for (int x = 0; x < min; ++x) {
                tableHTML.append(cols[x].getHTML(this.columns.get(x)));
            }
            if (min < colCount) {
                Cell empty = new Cell();
                for (int x = min; x < colCount; ++x) {
                    tableHTML.append(empty.getHTML(this.columns.get(x)));
                }
            }
            tableHTML.append(rowfooter);
        }
        tableHTML.append(footer);
        return tableHTML.toString();
    }

    public void addRow(Cell ... values) {
        this.rows.add(values);
    }

    public void addRow(String ... values) {
        Cell[] cells = new Cell[values.length];
        int index = 0;
        for (String v : values) {
            cells[index++] = new Cell(v);
        }
        this.rows.add(cells);
    }

    public Cell getCell(int row, int col) {
        Cell[] cells;
        if (row >= 0 && row < this.rows.size() && (cells = this.rows.get(row)).length > col) {
            return cells[col];
        }
        return null;
    }

    public void removeRow(int index) {
        if (index >= 0 && index < this.rows.size()) {
            this.rows.remove(index);
        }
    }

    public static void main(String ... arg) {
        HTMLTableMaker maker = new HTMLTableMaker();
        maker.setColumns("Col 1", "Col 2", "Col 3");
        maker.getColumn(0).setAlignment(0);
        maker.addRow("v1", "v2", "v3");
        maker.addRow("v4", "v5", "v6");
        maker.addRow("v7", "v8");
        maker.addRow("v9", "v10", "v11", "v12");
        FrmOutput f = new FrmOutput();
        f.setText(maker.getTable());
        f.setVisible(true);
    }

    public static class Column
    extends Cell {
        private int alignment = 1;

        public Column(String text, int align, boolean wrap) {
            this.text = text;
            this.wrapText = wrap;
            this.setAlignment(align);
            this.bold = true;
            this.underlined = true;
        }

        public void setAlignment(int align) {
            switch (align) {
                case 0: 
                case 1: 
                case 2: {
                    this.alignment = align;
                    break;
                }
            }
        }

        String getHTML() {
            String a = this.wrapText ? "<th " + this.alignment + ">" : "<th>";
            String b1 = this.bold ? "<b>" : "";
            String b2 = this.bold ? "</b>" : "";
            String u1 = this.underlined ? "<u>" : "";
            String u2 = this.underlined ? "</u>" : "";
            return a + b1 + u1 + this.text + u2 + b2 + "</th>";
        }
    }

    public static class Cell {
        protected String text = "";
        protected boolean wrapText = false;
        protected boolean bold = false;
        protected boolean underlined = false;

        public Cell() {
        }

        public Cell(String text) {
            this.text = text;
        }

        public Cell(String text, boolean wrap) {
            this.text = text;
            this.wrapText = wrap;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isWrapped() {
            return this.wrapText;
        }

        public void setWrapped(boolean wrap) {
            this.wrapText = wrap;
        }

        public boolean isBold() {
            return this.bold;
        }

        public void setBold(boolean b) {
            this.bold = b;
        }

        public boolean isUnderlined() {
            return this.underlined;
        }

        public void setUnderlined(boolean b) {
            this.underlined = b;
        }

        static String getAlignmentString(int alignment) {
            switch (alignment) {
                case 2: {
                    return "align=\"right\"";
                }
                case 1: {
                    return "align=\"center\"";
                }
            }
            return "align=\"left\"";
        }

        String getHTML(Column parentColumn) {
            String a = "<th " + Cell.getAlignmentString(parentColumn.alignment) + ">";
            String b1 = this.bold ? "<b>" : "";
            String b2 = this.bold ? "</b>" : "";
            String u1 = this.underlined ? "<u>" : "";
            String u2 = this.underlined ? "</u>" : "";
            return a + b1 + u1 + this.text + u2 + b2 + "</th>";
        }
    }
}

