/*
 * Decompiled with CFR 0.152.
 */
package InfoTools;

import SequenceEditorPanels.SequenceDocumentChangeListener;
import Sequences.DNA;
import UndoRedo.ChangeEvent;
import plot.Feature;
import plot.FrmOutput;
import plot.PLOTJ;
import plot.PLOTJPlugin;
import plot.ProjectDocument;

public class StatsReporter
extends PLOTJPlugin
implements SequenceDocumentChangeListener {
    FrmOutput output;
    ProjectDocument doc;
    String iconPath = "/icons/DNA.png";

    public StatsReporter() {
        this.setName("Sequence Stats Report");
        this.setDescription("Sequence Stats Report");
        this.setIcon(this.iconPath);
    }

    public void run() {
        this.doc = PLOTJ.getActiveDocument();
        this.output = PLOTJ.newOutputWindow();
        this.update();
        this.doc.addListener((SequenceDocumentChangeListener)this);
        this.output.setVisible(true);
    }

    private void update() {
        String msg;
        DNA seq = new DNA(this.doc.getSequence());
        this.output.setTitle("Status Reporter - " + this.doc.getName());
        Feature f = this.doc.getSelectedItem();
        if (f != null) {
            String seq2 = seq.getSequence(f.getStart(), f.getStop());
            int gc = DNA.getGCCount((String)seq2);
            int at = DNA.getATCount((String)seq2);
            msg = "Feature: " + f.getName() + "\nLength: " + seq2.length() + "bp\nGC count: " + gc + " (" + (float)gc / (float)seq2.length() * 100.0f + "%)\nAT count: " + at + " (" + (float)at / (float)seq.length() * 100.0f + "%)";
        } else if (seq.length() > 0) {
            int gc = seq.getGCCount();
            int at = seq.getATCount();
            msg = "Sequence: " + this.doc.getName() + "\nLength: " + seq.length() + "bp\nGC count: " + gc + " (" + (float)gc / (float)seq.length() * 100.0f + "%)\nAT count: " + at + " (" + (float)at / (float)seq.length() * 100.0f + "%)";
        } else {
            msg = "No sequence is present in the active window";
        }
        this.output.setText(msg);
    }

    public void propertyChanged(ChangeEvent ... evts) {
        for (ChangeEvent evt : evts) {
            if (evt.propertyID != 4 && evt.propertyID != 0 && evt.propertyID != 108) continue;
            this.update();
        }
    }
}

